// $Id: IWriter.cc,v 1.3 2003/04/10 07:56:46 ta_muto Exp $

#include <IWriter.h>

wax::IWriter::~IWriter()
{
}

bool wax::IWriter::writeQuote(const char* str)
{
	if(strstr(str, "'")) {
		if(strstr(str, "\"")) {
			return false;
		} else {
			writeStr("'");
			writeStr(str);
			writeStr("'");
		}
	} else {
		writeStr("\"");
		writeStr(str);
		writeStr("\"");
	}
	return true;
}

void wax::IWriter::writeHTMLEncodeChar(const char* str)
{
	for(int i = 0; str[i] != '\0'; i++) {
		switch(str[i]) {
		case '<':
			writeStr("&lt;");
			break;
		case '>':
			writeStr("&gt;");
			break;
		case '&':
			writeStr("&amp;");
			break;
		case '"':
			writeStr("&quot;");
			break;
		case ' ':
			writeStr("&nbsp;");
			break;
		default:
			write(&str[i], sizeof(char));
			break;
		}
	}
}
