// $Id: CCallTemplateTask.cc,v 1.10 2003/05/10 06:46:50 ta_muto Exp $

#include <views/CCallTemplateTask.h>
#include <CScriptlet.h>

wax::CCallTemplateTask::CCallTemplateTask()
{
	calledScript = NULL;
	disp = NULL;
}

wax::CCallTemplateTask::~CCallTemplateTask()
{
	if(calledScript != NULL)	delete calledScript;
	if(disp != NULL)	delete disp;
}

bool wax::CCallTemplateTask::parse(CEnvironment* runenv, xmlNodePtr cur)
{
	CXmlStr href(xmlGetProp(cur, (const xmlChar*) "href"));
	if(href.value() == NULL) {
		IError::message(ERR_ATTRIBUTE, "call-template::href");
		return false;
	}
	
	CXmlStr path(runenv->makePath(href.value()));
	if(path.value() != NULL) {
		calledScript = new CEnvironment(runenv->getRequest(), false);
		if(calledScript != NULL) {
			if(calledScript->prepare(path.value()) == true) {
				disp = CScriptlet::parse(calledScript);
				if(disp == NULL)	return false;
				return true;
			}
		}
	}
	IError::message(ERR_OUTOFMEMORY, LOCATION);
	return false;
}

bool wax::CCallTemplateTask::execute()
{
	return disp->execute();
}

void wax::CCallTemplateTask::output(IWriter* writer)
{
	disp->output(writer);
}
