// $Id: CXURemove.cc,v 1.4 2003/05/10 06:46:51 ta_muto Exp $

#include <xupdate/CXURemove.h>
#include <xupdate/CXUActionBase.h>

wax::CXURemove::CXURemove(const xmlChar* initConnect)
{
	select = NULL;
	if(initConnect != NULL) {
		connect = xmlStrdup(initConnect);
	} else {
		connect = NULL;
	}
}

wax::CXURemove::~CXURemove()
{
	if(select != NULL)	xmlFree(select);
	if(connect != NULL)	xmlFree(connect);
}

bool wax::CXURemove::parse(CEnvironment* runenv, xmlNodePtr cur)
{
	select = CXUActionBase::getSelect(cur);
	if(select == NULL)	return false;

	xmlDocPtr instanceData = CXUActionBase::parse(runenv, cur, vars, connect);
	if(instanceData != NULL)	xmlFreeDoc(instanceData);
	
	if(connect == NULL) {
		IError::message(ERR_CONNECT);
		return false;
	}
	return true;
}

bool wax::CXURemove::execute(CXmlSession* session)
{
	IXmlDB* db = session->getInstance(connect);
	if(db == NULL) {
		return false;
	}
	if(db->select(select) == false) {
		return false;
	}
	if(db->remove() == false) {
		return false;
	}
	return true;
}
