// $Id: CXURename.cc,v 1.4 2003/05/10 06:46:52 ta_muto Exp $

#include <xupdate/CXURename.h>
#include <xupdate/CXUActionBase.h>

wax::CXURename::CXURename(const xmlChar* initConnect)
{
	select = NULL;
	if(initConnect != NULL) {
		connect = xmlStrdup(initConnect);
	} else {
		connect = NULL;
	}
	name = NULL;
}

wax::CXURename::~CXURename()
{
	if(select != NULL)	xmlFree(select);
	if(connect != NULL)	xmlFree(connect);
	if(name != NULL)	xmlFree(name);
}

bool wax::CXURename::parse(CEnvironment* runenv, xmlNodePtr cur)
{
	select = CXUActionBase::getSelect(cur);
	if(select == NULL)	return false;
	
	xmlDocPtr instanceData = CXUActionBase::parse(runenv, cur, vars, connect);
	if(instanceData != NULL) {
		name = xmlNodeGetContent(instanceData->children);
		xmlFreeDoc(instanceData);
	}
	
	if(connect == NULL) {
		IError::message(ERR_CONNECT);
		return false;
	}
	if(name == NULL) {
		IError::message(ERR_RENAMETO);
		return false;
	}
	return true;
}

bool wax::CXURename::execute(CXmlSession* session)
{
	IXmlDB* db = session->getInstance(connect);
	if(db == NULL) {
		return false;
	}
	if(db->select(select) == false) {
		return false;
	}
	if(db->rename(name) == false) {
		return false;
	}
	return true;
}
