/*
 * Decompiled with CFR 0.152.
 */
package org.infodb.commons.db;

import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.commons.lang.StringEscapeUtils;
import org.infodb.commons.db.JDBCSupport;

public class CSVResultSet {
    private ResultSet rs;
    private boolean withHeader = true;
    private String separator = ",";

    public CSVResultSet(ResultSet rs) {
        this.rs = rs;
    }

    public void setWithHeader(boolean b) {
        this.withHeader = b;
    }

    public boolean getWithHeader() {
        return this.withHeader;
    }

    public void setSeparator(String sep) {
        this.separator = sep;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void output(PrintWriter writer) throws SQLException {
        int i;
        ResultSetMetaData meta = this.rs.getMetaData();
        int count = meta.getColumnCount();
        if (this.withHeader) {
            for (i = 1; i <= count; ++i) {
                if (i != 1) {
                    writer.print(this.separator);
                }
                writer.print("\"");
                writer.print(meta.getColumnName(i));
                writer.print("\"");
            }
            writer.println();
        }
        while (this.rs.next()) {
            for (i = 1; i <= count; ++i) {
                int type;
                if (i != 1) {
                    writer.print(this.separator);
                }
                if ((type = meta.getColumnType(i)) == 2005) continue;
                writer.print("\"");
                String value = null;
                if (type == 91) {
                    if (!JDBCSupport.isDateFormat()) {
                        value = this.rs.getString(i);
                    } else {
                        Timestamp ts = this.rs.getTimestamp(i);
                        if (ts != null) {
                            value = JDBCSupport.dateFormat(ts);
                        }
                    }
                } else {
                    value = this.rs.getString(i);
                }
                if (value != null) {
                    value = StringEscapeUtils.unescapeXml((String)value);
                    value = StringEscapeUtils.escapeCsv((String)value);
                    writer.print(value);
                }
                writer.print("\"");
            }
            writer.println();
        }
    }

    public void close() throws SQLException {
        this.rs.close();
    }
}

