/*
 * Decompiled with CFR 0.152.
 */
package org.infodb.commons.db;

import java.util.ArrayList;

public class SQLWhere {
    private JoinCondition join;
    private String cond;
    private Object[] args;

    public SQLWhere() {
        this.join = JoinCondition.AND;
        this.cond = null;
        this.args = null;
    }

    public SQLWhere(JoinCondition initJoin) {
        this.join = initJoin;
        this.cond = null;
        this.args = null;
    }

    public SQLWhere(JoinCondition initJoin, String initCond, Object ... argsObj) {
        this.join = initJoin;
        this.cond = initCond;
        this.args = argsObj;
    }

    public SQLWhere(String initCond, Object ... argsObj) {
        this.join = JoinCondition.AND;
        this.cond = initCond;
        this.args = argsObj;
    }

    public INCond beginIN(String target) {
        INCond handler = new INCond(target);
        return handler;
    }

    public void addIN(INCond handler, Object obj) {
        handler.addObj(obj);
    }

    public void endIN(INCond handler) {
        this.cond = handler.getCriteria();
        this.args = handler.getArgs();
    }

    public String getWhereString(boolean first) {
        StringBuilder sb = new StringBuilder(" ");
        if (first) {
            sb.append("WHERE ");
        } else {
            sb.append(this.join.toString());
            sb.append(" ");
        }
        sb.append(this.cond);
        return sb.toString();
    }

    public Object[] getObjects() {
        return this.args;
    }

    public static class INCond {
        private String target;
        private ArrayList<Object> objs;

        private INCond(String t) {
            this.target = t;
            this.objs = new ArrayList();
        }

        private void addObj(Object obj) {
            this.objs.add(obj);
        }

        private String getCriteria() {
            StringBuilder sb = new StringBuilder(this.target);
            sb.append(" IN (");
            for (int i = 0; i < this.objs.size(); ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append("?");
            }
            sb.append(")");
            return sb.toString();
        }

        private Object[] getArgs() {
            return this.objs.toArray();
        }
    }

    public static enum JoinCondition {
        AND,
        OR;

    }
}

