/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.OS;

public class RTFTransfer
extends ByteArrayTransfer {
    static RTFTransfer _instance = new RTFTransfer();
    static final String RTF = OS.NSRTFPboardType.getString();
    static final int RTFID = RTFTransfer.registerType(RTF);

    RTFTransfer() {
    }

    public static RTFTransfer getInstance() {
        return _instance;
    }

    @Override
    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkRTF(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        transferData.data = NSString.stringWith((String)object);
    }

    @Override
    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.data == null) {
            return null;
        }
        NSString nSString = (NSString)transferData.data;
        return nSString.getString();
    }

    @Override
    protected int[] getTypeIds() {
        return new int[]{RTFID};
    }

    @Override
    protected String[] getTypeNames() {
        return new String[]{RTF};
    }

    boolean checkRTF(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    @Override
    protected boolean validate(Object object) {
        return this.checkRTF(object);
    }
}

