/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleTableAdapter;
import org.eclipse.swt.accessibility.AccessibleTableEvent;
import org.eclipse.swt.accessibility.AccessibleTableListener;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSValue;

class AccessibleTableRow
extends Accessible {
    public AccessibleTableRow(Accessible accessible, int n) {
        super(accessible);
        this.index = n;
        this.addAccessibleControlListener(new AccessibleControlAdapter(){

            @Override
            public void getChildCount(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = Math.max(1, AccessibleTableRow.this.parent.getColumnCount());
            }

            @Override
            public void getChildren(AccessibleControlEvent accessibleControlEvent) {
                int n = Math.max(1, AccessibleTableRow.this.parent.getColumnCount());
                Object[] objectArray = new Object[n];
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
                for (int i = 0; i < n; ++i) {
                    accessibleTableEvent.column = i;
                    accessibleTableEvent.row = AccessibleTableRow.this.index;
                    for (int j = 0; j < AccessibleTableRow.this.parent.accessibleTableListeners.size(); ++j) {
                        AccessibleTableListener accessibleTableListener = AccessibleTableRow.this.parent.accessibleTableListeners.get(j);
                        accessibleTableListener.getCell(accessibleTableEvent);
                    }
                    if (accessibleTableEvent.accessible != null) {
                        accessibleTableEvent.accessible.parent = AccessibleTableRow.this;
                    }
                    objectArray[i] = accessibleTableEvent.accessible;
                }
                accessibleControlEvent.children = objectArray;
            }

            @Override
            public void getLocation(AccessibleControlEvent accessibleControlEvent) {
                Object object;
                NSObject nSObject;
                int n = Math.max(1, AccessibleTableRow.this.parent.getColumnCount());
                Accessible[] accessibleArray = new Accessible[n];
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
                for (int i = 0; i < n; ++i) {
                    accessibleTableEvent.column = i;
                    accessibleTableEvent.row = AccessibleTableRow.this.index;
                    for (int j = 0; j < AccessibleTableRow.this.parent.accessibleTableListeners.size(); ++j) {
                        AccessibleTableListener accessibleTableListener = AccessibleTableRow.this.parent.accessibleTableListeners.get(j);
                        accessibleTableListener.getCell(accessibleTableEvent);
                    }
                    accessibleArray[i] = accessibleTableEvent.accessible;
                }
                NSValue nSValue = (NSValue)accessibleArray[0].getPositionAttribute(-1);
                NSPoint nSPoint = nSValue.pointValue();
                int n2 = 0;
                int n3 = 0;
                for (int i = 0; i < accessibleArray.length; ++i) {
                    nSObject = (NSValue)accessibleArray[i].getSizeAttribute(-1);
                    object = ((NSValue)nSObject).sizeValue();
                    if (((NSSize)object).height > (double)n2) {
                        n2 = (int)((NSSize)object).height;
                    }
                    n3 = (int)((double)n3 + ((NSSize)object).width);
                }
                accessibleControlEvent.x = (int)nSPoint.x;
                NSArray nSArray = NSScreen.screens();
                nSObject = new NSScreen(nSArray.objectAtIndex(0L));
                object = ((NSScreen)nSObject).frame();
                accessibleControlEvent.y = (int)(((NSRect)object).height - nSPoint.y - (double)n2);
                accessibleControlEvent.width = n3;
                accessibleControlEvent.height = n2;
            }

            @Override
            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                int n = accessibleControlEvent.childID;
                accessibleControlEvent.detail = n == -1 ? 28 : 29;
            }

            @Override
            public void getFocus(AccessibleControlEvent accessibleControlEvent) {
                NSNumber nSNumber;
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
                accessibleTableEvent.column = 0;
                accessibleTableEvent.row = AccessibleTableRow.this.index;
                for (int i = 0; i < AccessibleTableRow.this.parent.accessibleTableListeners.size(); ++i) {
                    AccessibleTableListener accessibleTableListener = AccessibleTableRow.this.parent.accessibleTableListeners.get(i);
                    accessibleTableListener.getCell(accessibleTableEvent);
                }
                accessibleControlEvent.childID = accessibleTableEvent.accessible != null ? ((nSNumber = (NSNumber)accessibleTableEvent.accessible.getFocusedAttribute(-1)).boolValue() ? -1 : -2) : -2;
            }
        });
        this.addAccessibleTableListener(new AccessibleTableAdapter(){

            @Override
            public void isColumnSelected(AccessibleTableEvent accessibleTableEvent) {
                accessibleTableEvent.isSelected = false;
            }

            @Override
            public void isRowSelected(AccessibleTableEvent accessibleTableEvent) {
                AccessibleTableEvent accessibleTableEvent2 = new AccessibleTableEvent(this);
                accessibleTableEvent2.row = accessibleTableEvent.row;
                for (int i = 0; i < AccessibleTableRow.this.parent.accessibleTableListeners.size(); ++i) {
                    AccessibleTableListener accessibleTableListener = AccessibleTableRow.this.parent.accessibleTableListeners.get(i);
                    accessibleTableListener.isRowSelected(accessibleTableEvent2);
                }
                accessibleTableEvent.isSelected = accessibleTableEvent2.isSelected;
            }
        });
    }

    void getChildAtPoint(AccessibleControlEvent accessibleControlEvent) {
        Object object;
        int n;
        int n2 = Math.max(1, this.parent.getColumnCount());
        Accessible[] accessibleArray = new Accessible[n2];
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        for (n = 0; n < n2; ++n) {
            accessibleTableEvent.column = n;
            accessibleTableEvent.row = this.index;
            for (int i = 0; i < this.parent.accessibleTableListeners.size(); ++i) {
                object = this.parent.accessibleTableListeners.get(i);
                object.getCell(accessibleTableEvent);
            }
            accessibleArray[n] = accessibleTableEvent.accessible;
        }
        for (n = 0; n < accessibleArray.length; ++n) {
            NSValue nSValue = (NSValue)accessibleArray[n].getPositionAttribute(this.index);
            object = nSValue.pointValue();
            NSValue nSValue2 = (NSValue)accessibleArray[n].getSizeAttribute(this.index);
            NSSize nSSize = nSValue2.sizeValue();
            if (!(((NSPoint)object).x <= (double)accessibleControlEvent.x) || !((double)accessibleControlEvent.x <= ((NSPoint)object).x + nSSize.width)) continue;
            accessibleArray[n].parent = this;
            accessibleControlEvent.accessible = accessibleArray[n];
            break;
        }
    }
}

