<?php
/*
*    Weasy (parse.php)
*/


$entryNames = array('title', 'body', 'date');

$syntax   = array();


$syntax[] = array('symbol1'=>'{', 'symbol2'=>'}', 'symbol1HTMLEntity'=>'&#123;', 'symbol2HTMLEntity'=>'&#125;',

                  'tag1'=>'<pre>',     'tag2'=>'</pre>',   'isEnclose'=>false);


$syntax[] = array('symbol1'=>'*', 'symbol2'=>'*', 'symbol1HTMLEntity'=>'&#042;', 'symbol2HTMLEntity'=>'&#042;',

                  'tag1'=>'<b>',       'tag2'=>'</b>',     'isEnclose'=>true);



$syntax[] = array('symbol1'=>'_', 'symbol2'=>'_', 'symbol1HTMLEntity'=>'&#095;', 'symbol2HTMLEntity'=>'&#095;',

                  'tag1'=>'<u>',       'tag2'=>'</u>',     'isEnclose'=>true);



$syntax[] = array('symbol1'=>'=', 'symbol2'=>'=', 'symbol1HTMLEntity'=>'&#061;', 'symbol2HTMLEntity'=>'&#061;', 

                  'tag1'=>'</p><h3>',  'tag2'=>'</h3><p>',  'isEnclose'=>true);

$syntax[] = array('symbol1'=>'[', 'symbol2'=>']', 'symbol1HTMLEntity'=>'&#091;', 'symbol2HTMLEntity'=>'&#093;',

                  'tag1'=>'',          'tag2'=>'',         'isEnclose'=>false);


function parse ($filedata){

 global $syntax;


  $lines = explode(PHP_EOL, $filedata);
  $flag  = false;
  $entry = '';
  $htmlEntities = array();

  $data['body'] = '<p>';

  unset($filedata);



 /*===============================
  *  項目ごとに分ける
  *==============================*/

  foreach($lines as $line){

    if($flag)
      $data[$entry] .= $line."<br>";


    //項目を発見
    if(preg_match('/([[:space:]]|)(.*[^\\\\])\:(.*)([[:space:]]|)$/', $line, $tmp)){


      if(isEntryName(trim($tmp[2]))){

        if(isset($data[$entry]))
          $data[$entry] = preg_replace('/.{'.strlen(trim($line."<br>")).'}$/', '', $data[$entry]);

        $entry        = $tmp[2];
        $data[$entry] = $tmp[3];
        $flag         = true;
      }
    }
  }

  unset($lines);


 /*===============================
  *  bodyを解析
  *==============================*/

  if(!isset($data['body']))
    return false;


  //$htmlEntitiesをつくる
  foreach($syntax as $s){

    $htmlEntities["\\{$s['symbol1']}"]  = $s['symbol1HTMLEntity'];
    $htmlEntities["\\{$s['symbol2']}"]  = $s['symbol2HTMLEntity'];
    $htmlEntities2[$s['symbol1']]       = $s['symbol1HTMLEntity'];
    $htmlEntities2[$s['symbol2']]       = $s['symbol2HTMLEntity'];
  }


  foreach($syntax as $s){

    //エスケープ
    $data['body'] = strtr($data['body'], $htmlEntities);

    //タグで囲むだけのもの
    if($s['isEnclose']){

      while(preg_match('/'.preg_quote($s['symbol1']).'(.*?)'.preg_quote($s['symbol2']).'/', $data['body'], $tmp))
        $data['body'] = str_replace($tmp[0], "{$s['tag1']}{$tmp[1]}{$s['tag2']}", $data['body']);


    //特別な処理がいるもの
    }else{

      switch($s['symbol1']){

        case '[':

          while(preg_match('/'.preg_quote($s['symbol1']).'http\:\/\/(.*?)(\:(.*?)|)'.preg_quote($s['symbol2']).'/', $data['body'], $tmp)){

            // 間違って変換された記号を元に戻す
           foreach($syntax as $s){
             $tmp[1] = str_replace($s['tag1'], $s['symbol1'], $tmp[1]);
             $tmp[1] = str_replace($s['tag2'], $s['symbol2'], $tmp[1]);
           }

            if(isset($tmp[3]))
              $data['body'] = str_replace($tmp[0], "<a href=\"http://{$tmp[1]}\">{$tmp[3]}</a>", $data['body']);
            else
              $data['body'] = str_replace($tmp[0], "<a href=\"http://{$tmp[1]}\">{$tmp[1]}</a>", $data['body']);
          }



        break;
        case '{':

          while(preg_match('/\{((.|\n)*?)\<br\>\}/', $data['body'], $tmp)){

            $tmp2 = strtr($tmp[1], $htmlEntities2);
            $data['body'] = str_replace("{$s['symbol1']}{$tmp[1]}<br>{$s['symbol2']}", "{$s['tag1']}{$tmp2}{$s['tag2']}", $data['body']);
          }

        break;
      }
    }
  }


  return $data;
}




function isEntryName ($name){

 global $entryNames;

  foreach($entryNames as $entryName){

    if($name === $entryName)
      return true;
  }

  return false;
}
