# -*- coding: utf-8 -*-
import sys , re , urlparse

# common debuglv
__debuglv = 0
def debug_out (lv,msg):
    """

    debug out .
    lv  : debug level
    msg : debug message
    """
    global __debuglv
    if __debuglv >= lv:
        print >>sys.stderr,msg
def set_debuglv(lv):
    """

    reset debug .
    lv  : new debug level
    """
    global __debuglv
    __debuglv = lv

def get_debuglv():
    """

    debug lv .
    """
    return __debuglv

class WebMonitorError:
    """
    Exception class.

    """
    def __init__(self,msg):
        self.msg = msg

    def get_message(self):
        """
        
        Get error message.
        """
        return self.msg

def to_string(input,charset='utf-8'):
    """

    convert to writeable string.
    input   : source string
    charset : unicode encoding

    """
    if  input == None:
        return ''
    if not isinstance(input,basestring):
        return str(input)
    if isinstance(input,unicode):
        return input.encode(charset)
    return input

def to_unicode(input,charset='utf-8'):
    """

    convert to wide charactor string.
    input   : source string
    charset : unicode encoding

    """
    if  input == None:
        return ''
    if not isinstance(input,basestring):
        return str(input)
    if isinstance(input,unicode):
        return input
    return unicode(input,charset)

def eval_relative_path(basepath,url):
    """

    Convert from relative path to absolute path .
    """
    if re.compile('^/').match(url) != None:
        # abs path
        return url
    else:
        # relative
        match = re.compile('^(/.*?)?([^/]*)$').search(basepath)
        path = match.group(1)
        if path == None:
            path = '/'
        return path + url
    
def eval_relative_url(baseurl,url):
    """

    Convert from relative url to absolute url .

    Support :
    - Full path
    - Absolute path with method omission
    - Relative path 
    - Redirect 

    * I have enhanced httpsproxy_urllib2 for redirect supporting.
       
      - Add urllib2.Request::set_url(self,url)
      - Enhanced urllib2.HTTPRedirectHandler::redirect_request()
    """
    if re.compile('^(?:http://|https://)').match(url.lower()) != None:
        # abs url
        debug_out(7,'gen_full_url : ' + url)
        return url
    urischeme,urihost,uripath,uricomment,uriquery,urifrag = urlparse.urlparse(baseurl)
    debug_out(7,'gen_full_url : ' + urischeme + '://' + urihost + eval_relative_path(uripath,url))
    return urischeme + '://' + urihost + eval_relative_path(uripath,url)

