# -*- coding: utf-8 -*-
#----------------------------------------------------------------------
# Copyright (c) 2009 Hiroaki Kubota 
#
# This Software is released under the MIT License:
# http://www.opensource.org/licenses/mit-license.html
#
# [Require libraries]
#  - html5lib => http://code.google.com/p/html5lib
#      Distributed with MIT License
#
#  - httpsproxy_urllib2 => http://pypi.python.org/pypi/httpsproxy_urllib2
#      Distributed with Python License
#      Enhanced  for following Moved-Temporary (Redirect).
#----------------------------------------------------------------------

"""
Web monitor FW.

This is a testing framwork on web.

Functions:
 - HTTP/HTTPS
 - HTTP/HTTPS Proxies.
 - Fixed url request.
 - Keeps session cookies.
 - Follows Moved-Temporary (Redirect).
 - Finds <A> tags by text and generates next request.
 - Analyzes forms and generates next request with custom.

Code generator example:
 $ python ./webmonitor/wm_server.py -p http://some.proxy.host -p https://some.proxy.host
  > Access to http://localhost:8899

Source example:

import sys
import webmonitor
webmonitor.set_debuglv(1)
headers = [('User-agent', 'Mozilla/5.0 (X11; U; Linux i686 (x86_64); en; rv:1.9.0.8) Gecko/2009032608 Firefox/3.0.8'),
           ('Accept', 'text/html,application/xhtml xml,application/xml;q=0.9,*/*;q=0.8'),
           ('Accept-Language', 'en-us;q=0.7,en;q=0.3'),
           ('Accept-Charset', 'utf-8;q=0.7,*;q=0.7'),
           ('Keep-Alive', 'closed')]
proxies = {'http': 'http://some.proxy.host',
           'https': 'https://some.proxy.host'}
client = webmonitor.WebMonitorHTTPWrapper(headers,proxies)
case = webmonitor.WebMonitorCase(client)
# --------- Google ------------
case.add_step(webmonitor.WebMonitorStepUrl('http://google.com/en'),
              [webmonitor.WebMonitorValidatorTitle(u'Google')])
# --------- foobar - Google Search (input 'foobar') ------------
parms = {}
parms[u'q']= u'foobar'
case.add_step(webmonitor.WebMonitorStepForm(parms,0),
              [webmonitor.WebMonitorValidatorTitle(u'foobar - Google Search')])
# --------- foobar - Google Search (click '2') ------------
case.add_step(webmonitor.WebMonitorStepATag(u'Next',0),
              [webmonitor.WebMonitorValidatorTitle(u'foobar - Google Search')])
#----- Execute -----------------------------------
try:
    case.execute_all()
except webmonitor.WebMonitorError,(ex): 
    print >>sys.stderr, ex.get_message()
"""

__author__ = "Hiroaki Kubota <hiroaki.kubota@mail.crumb.jp>"
__date__ = "2009/03/16"
__credits__ = ""
__version__ = "$Revision: 0 $"

from wmframe import *

class WebMonitorLoopCallback:
    """
    Default loop callback

    """
    def success(self):
        """

        Per success.
        """
        pass
    def error(self,ex):
        """

        Per error.
        msg : error message
        """
        pass
    def fatal(self):
        """

        Fatal error for monitor loop.
        """
        pass
    
def web_monitor_loop(case,callback=WebMonitorLoopCallback()):
    """

    Testing loop.
    """
    while True:
        try:
            case.execute_all()
            callback.success()
        except WebMonitorError,(ex):
            callback.error(ex)
        except:
            callback.fatal()
            # raise  # @@@
            return
        else:
            pass

