# -*- coding: utf-8 -*-
from wmcommon import *
from wmhttp import *
from wmhtml import *
import time
from sets import Set

class WebMonitorStep:
    """
    Test case step interface.

    """
    def __init__ ( self, interval = 0 ):
        """

        Test case step interface.
        interval     : sleep time (sec) before request.
        """
        self.interval = interval

    def gen_form(self,req,doc):
        """

        Generate WebMonitorForm instance from last request and test step datas.
        req  : urllib2.Request instance
        doc  : Responsed html document node
        """
        pass

    def get_interval(self):
        """

        Return request interval.
        """
        return self.interval
    
class WebMonitorStepUrl(WebMonitorStep):
    """
    Fixed url step.

    """
    def __init__ ( self, url , interval = 0 ):
        WebMonitorStep.__init__(self,interval)
        self.url = url
        
    def gen_form(self,req,doc):
        return WebMonitorForm(self.url).gen_request()
    
class WebMonitorStepATag(WebMonitorStep):
    """
    <A> tag link step

    """
    def __init__ ( self, txt, no = 0 , interval = 0):
        WebMonitorStep.__init__(self,interval)
        self.txt = txt
        self.no  = no
    def gen_form(self,req,doc):
        forms = get_href(req,doc,self.txt)
        if len(forms) <= self.no:
            raise WebMonitorError('WebMonitorStepATag => Invalid form number ! (different html ?) href-txt :' + to_unicode(self.txt))
        form = forms[self.no]
        return form.gen_request()

class WebMonitorStepForm(WebMonitorStep):
    """
    Form request step

    """
    def __init__ ( self, data = None , no = 0 , interval = 0 ):
        WebMonitorStep.__init__(self,interval)
        self.data = data
        self.no  = no
    def gen_form(self,req,doc):
        forms = get_forms(req,doc)
        if len(forms) <= self.no:
            raise WebMonitorError('WebMonitorStepForm => Invalid form number ! (different html ?) num of forms : ' + str(len(forms)) + ' require : ' + str(self.no))
        form = forms[self.no]
        if self.data != None:
            for p,v in self.data.iteritems():
                form.parms[p] = v
        return form.gen_request()

class WebMonitorValidator:
    """
    Per step validator

    """
    def do ( self , req , doc ):
        """

        Callback function for validation.
        if validation succesful returns None , or string of error message.
        req : Request object.
        doc : Responsed html document node 
        """
        return None

class WebMonitorValidatorTitleError(WebMonitorError):
    """
    Html title validator error

    """
    pass

class WebMonitorValidatorTitle(WebMonitorValidator):
    """
    Html title validator

    """
    def __init__ ( self , title ):
        self.title = title

    def do ( self , req , doc ):
        title = get_title(doc)
        if self.title == title:
            return 
        raise WebMonitorValidatorTitleError('Title unmatch ! expects:' + self.title + ' returnd:' + title)

class WebMonitorValidatorHtmlError(WebMonitorError):
    """
    Html arbitrariness tag validator error

    """
    pass

class WebMonitorValidatorHtml(WebMonitorValidator):
    """
    Html arbitrariness tag validator

    """
    def __init__ ( self , path , str ):
        self.path = path
        self.str  = str

    def do ( self , req , doc ):
        nodes = xpath(self.path,doc)
        regex = re.compile(self.str)
        for node in nodes:
            str = ''
            if node.nodeType == node.TEXT_NODE:
                str = node.data
            elif node.nodeType == node.CDATA_SECTION_NODE:
                str = node.data
            elif node.nodeType == node.ATTRIBUTE_NODE:
                str = node.nodeValue
            if regex.match(str):
                return
        raise WebMonitorValidatorHtmlError('Html unmatch ! xpath:' + self.path + 'expects:' + to_unicode(self.str))

def form2str(form):
    ret = form.method
    for p,v in form.parms.iteritems():
        p = to_string(p,form.charset)
        v = to_string(v,form.charset)
        ret = ret + p + v
    match = re.compile('^([^#]+)').search(form.url)
    ret = ret + match.group(1)
    return ret
        
class WebMonitorValidatorATagError(WebMonitorError):
    """
    A tag href attribute validator error

    """
    pass

class WebMonitorValidatorATag(WebMonitorValidator):
    """
    A tag href attribute validator

    """
    def __init__ ( self , http_client ):
        self.http_client = http_client

    def do ( self , req , doc ):
        forms = get_href(req,doc,None)
        ret = ''
        hists = Set()
        for form in forms:
            check = form2str(form)
            if check in hists:
                continue
            else:
                hists.add(check)
            new_req = form.gen_request()
            try:
                html,info = self.http_client.request(new_req)
            except WebMonitorError,(ex):
                ret = ret + '\n' + 'Deadlink <A>:' + to_unicode(form.url)
                if get_debuglv() > 1:
                    ret = ret + to_unicode(info)
        if ret == '':
            return
        raise WebMonitorValidatorATagError(ret)

class WebMonitorValidatorLinkError(WebMonitorError):
    """
    Link tag href attribute validator error

    """
    pass

class WebMonitorValidatorLink(WebMonitorValidator):
    """
    Link tag href attribute validator

    """
    def __init__ ( self , http_client ):
        self.http_client = http_client
    def do ( self , req , doc ):
        forms = get_link(req,doc,None)
        ret = ''
        hists = Set()
        for form in forms:
            check = form2str(form)
            if check in hists:
                continue
            else:
                hists.add(check)
            new_req = form.gen_request()
            try:
                html,info = self.http_client.request(new_req)
            except WebMonitorError,(ex):
                ret = ret + '\n' + 'Deadlink <LINK>:' + to_unicode(form.url)
                if get_debuglv() > 1:
                    ret = ret + to_unicode(info)
        if ret == '':
            return
        raise WebMonitorValidatorLinkError(ret)


class WebMonitorValidatorScriptError(WebMonitorError):
    """
    Script tag src attribute validator error

    """
    pass

class WebMonitorValidatorScript(WebMonitorValidator):
    """
    Script tag src attribute validator

    """
    def __init__ ( self , http_client ):
        self.http_client = http_client

    def do ( self , req , doc ):
        forms = get_script(req,doc)
        ret = ''
        hists = Set()
        for form in forms:
            check = form2str(form)
            if check in hists:
                continue
            else:
                hists.add(check)
            new_req = form.gen_request()
            try:
                html,info = self.http_client.request(new_req)
            except WebMonitorError,(ex):
                ret = ret + '\n' + 'Deadlink <SCRIPT>:' + to_unicode(form.url)
                if get_debuglv() > 1:
                    ret = ret + to_unicode(info)
        if ret == '':
            return
        raise WebMonitorValidatorScriptError(ret)

class WebMonitorValidatorImgError(WebMonitorError):
    """
    Img tag src attribute validator error

    """
    pass

class WebMonitorValidatorImg(WebMonitorValidator):
    """
    Img tag src attribute validator

    """
    def __init__ ( self , http_client ):
        self.http_client = http_client

    def do ( self , req , doc ):
        forms = get_img(req,doc)
        ret = ''
        hists = Set()
        for form in forms:
            check = form2str(form)
            if check in hists:
                continue
            else:
                hists.add(check)
            new_req = form.gen_request()
            try:
                html,info = self.http_client.request(new_req)
            except WebMonitorError,(ex):
                ret = ret + '\n' + 'Deadlink <IMG>:' + to_unicode(form.url)
                if get_debuglv() > 1:
                    ret = ret + to_unicode(info)
        if ret == '':
            return
        raise WebMonitorValidatorImgError(ret)

class WebMonitorCase:
    """
    Test case runner.

    """
    def __init__ ( self,http_client ):
        self.steps       = []
        self.validates   = []
        self.http_client = http_client
        self.req         = None
        self.html        = None
        self.info        = None
        self.doc         = None
    def reset ( self ):
        """
        Reset sesssion.
        
        """
        self.http_client.reset()
        self.req         = None
        self.html        = None
        self.info        = None
        self.doc         = None
    def add_step( self, step , validators = None ):
        """
        Add step object.

        step       : WebMonitorStep instance
        validators : WebMonitorValidator instance array
        """
        self.steps.append(step)
        if validators == None:
            validators = []
        self.validates.append(validators)

    def execute_step ( self, step , validators ):
        """
        Execute the step.

        step : WebMonitorStep instance.
        """
        time.sleep(step.get_interval())
        self.req            = step.gen_form(self.req,self.doc)
        self.html,self.info = self.http_client.request(self.req)
        self.doc            = get_doc(self.html)
        if get_debuglv() > 1:
            title = get_title(self.doc)
            debug_out(2,title)
        for validator in validators:
            validator.do(self.req,self.doc)
        
    def execute_no ( self, no ):
        """
        Execute the step.

        no : Number of registerd.
        """
        self.execute_step(self.steps[no],self.validates[no])

    def execute_tail ( self ):
        """
        Execute the step.

        """
        self.execute_step(self.steps[len(self.steps)-1],self.validates[len(self.validates)-1])

    def execute_all( self ):
        """
        Execute all steps.

        """
        self.reset()
        i = 0
        for step in self.steps:
            self.execute_step(step,self.validates[i])
            i = i + 1
