﻿$spilt_size = 1024 * 512;	//分割するサイズ
$reset_password_diff = 1000 * 60 * 60;	//ルームパスワードをリセットする間隔
$gc_time_interval = 1000 * 60 * 60;	//ゴミ掃除を行う間隔
$ip_ban_list_file_name = "ipbanlist.txt";	//アクセスを禁止するIPが記録されているファイル
$room_configure_file_name = "roomlist.txt";	//ルームの設定が記録されているファイル
$system_name = "system";	//システム発言を表す名前
$log_directory = "log";	//ログファイルを置くフォルダー
$log_file_name = "logfile%d.txt";	//ログファイル名(%dはそのままにしておくこと)
$splited_log_file_name = "logfile%d_%s.txt"	//分割後のファイル名(%dと%sはそのままにしておくこと)

var resource = require("./resources.js");
var config = require("./configure.js");
var security = require("./security.js");
var lazy = require("lazy");
var fs = require("fs");
var async = require("async");
var path = require("path");
var util = require("util");
var cookie = require("express/node_modules/cookie");
var connectUtils = require("express/node_modules/connect/lib/utils");

var clients = new Array();

var sessionStore;

module.exports = function(app,server,express,session){
	sessionStore = session;
	app.get("/chat", chat_proc);
	app.all("/log/*",express.basicAuth(auth_proc));
	app.get("/log/*",log_proc);
	app.all("/chat/admin",express.basicAuth(auth_proc));
	app.get("/chat/admin", admin_proc);
	app.post("/chat/admin",admin_postproc);

	var io = require("socket.io").listen(server);
	io.configure("production", function(){
		io.set("transports", config.transports);
		io.enable("browser client minification");  // minified されたクライアントファイルを送信する
		io.enable("browser client etag");          // バージョンによって etag によるキャッシングを有効にする
		io.set("log level", 1);                    // ログレベルを設定(デフォルトより下げている)
	});

	for(var i = 0; i < config.max_room_number; i++)
	{
		clients[i] =io
		.of(GetNameFromRoomNumber(i))
		.authorization(ParseAuthorization)
		.on("connection",ParseConnect);
	}
};

function chat_proc(req, res){
	var info = new security.SessionInfomation(false);
	req.session.items = info;

	var room_number = 0;
	if(typeof(req.query.rno) != "undefined")
		room_number = req.query.rno;
	res.render("chat",{rno:room_number,token:req.session._csrf});
}

function auth_proc(user, pass) {
	return user === config.username && pass === config.password;
}

function log_proc(req, res) {
	res.sendfile(__dirname + req.url);
}

function admin_postproc(req,res){
	if(typeof(req.body.erase) != "undefined")
	{
		removeLog(req.body.file,function(){
			res.redirect("/chat/admin");
		});
	}
	if(typeof(req.body.registor) != "undefined")
	{
		ipbanlist.Update(req.body.newbanlist,function(){
			res.redirect("/chat/admin");
		});
	}
	if(typeof(req.body.updateroom) != "undefined")
	{
		$rooms.Update(req.body,function(){
			res.redirect("/chat/admin");
		});
	}
}

function admin_proc(req,res)
{
	var info = new security.SessionInfomation(true);
	req.session.items = info;
	var iplist = ipbanlist.GetText();

	fs.readdir($log_directory,function(err,list){
		res.setHeader("X-FRAME-OPTIONS","DENY");
		res.render("admin", {
			files: list,
			log_directory:$log_directory,
			ipbanlist:iplist,
			token:req.session._csrf,
			roomlist:$rooms.GetMessage()
		});
	});
}

function removeLog(files,callback)
{
	if(typeof(files) == "undefined")
	{
		if(typeof(callback) == "function")
			callback();
		return;
	}

	async.map(files,
	function(item,callback){
		fs.unlink($log_directory + "/" + item,callback);
	},
	function(err,results){
		if(typeof(callback) == "function")
			callback();
	});
}

//RoomInfomationCollecionクラス
function RoomInfomationCollection()
{
	var MySQLPool = new require("./mysql_pool.js");
	var pool = new MySQLPool({
				host     : config.db_host,
				user     : config.db_user,
				password : config.db_password,
				port     : config.db_port,
				database : config.db_name,
			});
	var collection = {};
	this.Get = function(rno){
		return collection[rno];
	}
	this.IsContains = function(rno){
		return rno in collection;
	};
	this.GetMessage = function(){
		var retval = new Array();
		for(var rno in collection)
		{
			item={};
			item.applyflag = !$rooms.Get(rno).IsVolatile();
			item.password = collection[rno].password;
			if(item.password == null)
				item.password = "";
			item.hiddenlog = collection[rno].hiddenlog;
			retval.push(item);
		}
		return retval;
	};
	this.GetKeys = function(){
		var retval = {};
		for(var rno in collection)
		{
			retval[rno] = {};
		}
		return retval;
	}
	this.Update = function(data,callfunc){
		Clear();
		async.waterfall([
			function(next){
				pool.query("TRUNCATE TABLE rooms",null,next);
			},
			function(result,next){
				console.log(util.inspect(data));
				var items = new Array();
				var config = data.config;
				for(var i = 0; i < config.length; i++)
				{
					var rno = Number(config[i].applyflag);
					if(isNaN(rno))
						continue;
					var password,romonly;
					if(typeof(config[rno].password)=="undefined")
						password = null;
					else if(config[rno].password == "")
						password = null;
					else
						password = config[rno].password;
					if(typeof(config[rno].hiddenlog)=="undefined")
						romonly = false;
					else
						romonly = config[rno].hiddenlog == "romonly";

					Add(rno,password,romonly);
					items.push(new Array(rno,password,romonly));
				}
				pool.query("INSERT INTO rooms VALUES ?",[items],callfunc);
			}
		],callfunc);
	}
	function GetRoomList(callback){
		Clear();
		async.waterfall([
			function(next){
				pool.query("SELECT * FROM rooms",null,next);
			},
			function(result,next){
				for(var i = 0; i < result.length; i++)
				{
					//MySQLではTINYINTが使われている
					Add(result[i].number,result[i].password,result[i].hiddenlog != 0);
				}
				next(null,null);
			}
		],callback);
	}
	function Clear(){
		collection = {};
		for(var i = 0; i < config.max_room_number; i++)
			Add(i,null,null);
	};
	function Add(rno,pass,hiddenlogflag){
		collection[rno] = new RoomInfomation(pass,hiddenlogflag);
		if(pass != null)
			collection[rno].owner = $system_name;
	};
	var $gc_interval_id = setInterval(function(){
		for(var rno in this.rom_list)
			collection[rno].GCRomList();
	},$gc_time_interval);
	GetRoomList();
}

//RoomInfomationクラス
function RoomInfomation(pass,hiddenlogflag)
{
	this.password = pass;
	this.rom_list = {};
	this.authed_list = {};
	this.owner = null;
	this.time = null;
	this.hiddenlog = hiddenlogflag;
	this.GetConfig = function(){
		var roomconfig = {};
		if(this.IsVolatile() == false)
		{
			if(this.IsFixedPassword())
				roomconfig.type = 2;
			else if(this.IsHiddenLogFromRom())
				roomconfig.type = 3;
			else
				roomconfig.type = 1;
			roomconfig.IsOwned = !this.IsFirstAuth();
		}else{
			roomconfig.type = 0;
		}
		return roomconfig;
	}
	this.IsVolatile = function(){
		return this.owner == null &&
			this.password == null &&
			this.time == null &&
			this.hiddenlog == null;
	}
	this.GetRomCount = function(){
		var count = 0;
		for(var key in this.rom_list)
			count++;
		return count;
	};
	this.AddRom = function(ip){
		var date = new Date();
		this.rom_list[ip] = {time:date.getTime()};
	};
	this.RemoveRom = function(ip){
		delete this.rom_list[ip];
	};
	this.Reset = function(owner){
		var date = new Date();
		var time = date.getTime();
		this.password = null;
		this.authed_list = {};
		this.owner = owner;
		this.time = time;
	};
	this.IsFirstAuth = function(){
		return this.owner == null;
	};
	this.IsAuthed = function(name){
		return name == this.owner ||
			name in this.authed_list;
	};
	this.IsHiddenLogFromRom = function(){
		return this.hiddenlog;
	};
	this.IsFixedPassword = function(){
		return this.owner == $system_name;
	};
	this.IsOwner = function(name){
		return this.owner == name;
	};
	this.IsTimeout = function(){
		var date = new Date();
		var current_time = date.getTime();
		return !this.IsFixedPassword() &&
			current_time - this.time >= $reset_password_diff;
	};
	this.RemoveAuth = function(name)
	{
		delete this.authed_list[name];
	};
	this.Auth = function(name,password){
		if(this.password != password)
			return false;
		var date = new Date();
		var time = date.getTime();
		this.time = time;
		this.authed_list[name] = "";
		return true;
	};
	this.SetPassword = function(owner,password){
		if(owner == this.owner &&
			!this.IsFixedPassword() &&
			!this.IsHiddenLogFromRom())
		{
			var date = new Date();
			this.time = date.getTime();
			this.password = password;
			return true;
		}
		return false;
	};
	this.GCRomList = function(){
		var date = new Date();
		var current_time = date.getTime();
		for(var ip in this.rom_list)
		{
			if(current_time - this.rom_list[ip].time >= $gc_time_interval)
				delete this.rom_list[ip];
		}
	};
}

//IPBANクラス
function IpBanCollecion()
{
	var MySQLPool = new require("./mysql_pool.js");
	var pool = new MySQLPool({
				host     : config.db_host,
				user     : config.db_user,
				password : config.db_password,
				port     : config.db_port,
				database : config.db_name,
			});
	var collection = {};
	this.IsBaned = function(ip){
		return collection[ip] == "r";
	}
	this.IsBlockedToWrite = function(ip){
		return ip in collection;
	}
	this.GetText = function(){
		var text = "";
		for(var key in collection)
		{
			if(collection[key] == "")
				text += key + "\r\n";
			else
				text += key + ":" + collection[key] + "\r\n";
		}
		return text;
	}
	this.Update = function(text,callfunc){
		collection = {};
		async.waterfall([
			function(next){
				pool.query("TRUNCATE TABLE ipbanlist",null,next);
			},
			function(result,next){
				var items = new Array();
				lines = text.split("\r\n");
				for(var i = 0; i < lines.length; i++)
				{
					var token = lines[i].split(":");
					var ip = token[0];
					if(ip == "")
						continue;
					if(token.length == 1)
						collection[ip] = "";
					else
						collection[ip] = token[1];
					items.push(new Array(ip,collection[ip]));
				}
				pool.query("INSERT INTO ipbanlist VALUES ?",[items],next);
			},
		],callfunc);
	}
	function GetIpBanList(callfunc)
	{
		async.waterfall([
			function(next){
				pool.query("SELECT * FROM ipbanlist",null,next);
			},
			function(result,next){
				for(var i = 0; i < result.length; i++)
					collection[result[i].ip] = result[i].type;
				next(null,null);
			},
		],callfunc);
	}
	GetIpBanList();
}

var ipbanlist = new IpBanCollecion();
var $rooms = new RoomInfomationCollection();

createLogDirectory();

function createLogDirectory()
{
	fs.exists($log_directory,function(exists){
		if(exists == false)
			fs.mkdirSync($log_directory);
	});
}

function ParseConnect(socket)
{
	var ip = GetClientIPAdress(socket);
	console.log("connected from %s",ip);

	var rno = GetRoomNumberFromName(socket.namespace.name);

	var room = $rooms.Get(rno);

	room.AddRom(ip);

	var roomconfig = room.GetConfig();
	socket.json.emit("send roominfo",roomconfig);

	var romcount = room.GetRomCount();
	socket.json.emit("send romcount",romcount);
	socket.json.broadcast.emit("send romcount",romcount);

	socket.on("get pastLog", function (msg) {
		ParseGetPastLog(socket,msg);
	});
	socket.on("join",function(msg){
		ParseJoin(socket,msg);
	});
	socket.on("quit",function(msg){
		ParseQuit(socket,msg);
	});
	socket.on("set password",function(msg){
		ParseSetPassword(socket,msg);
	});
	socket.on("send msg", function (msg) {
		ParseSendMsg(socket,msg);
	});
	socket.on("disconnect", function (msg) {
		ParseDisconnect(socket,msg);
	});
}

function ParseAuthorization(handshakeData, callback)
{
	if(handshakeData.headers.cookie) {
		var signedCookie = cookie.parse(handshakeData.headers.cookie);
		var sessionID = connectUtils.parseSignedCookies(signedCookie, $secret)["connect.sid"];
		sessionStore.get(sessionID, function (err, session) {
			var result = null;
			if (ipbanlist.IsBaned(handshakeData.address.address))
				result = "failed get from session store";
			else if(err)
				result = err;
			else if(typeof(session) == "undefined" || typeof(session._csrf) == "undefined")
				result = "session is undefined";
			else if(handshakeData.query.token != session._csrf)
				result = "invaild token";
			if(result == null)
				handshakeData.sessionID = sessionID;
			callback(result,result == null && !err);
		});
	} else {
		return callback("failed get cookie", false);
	}
}

function ParseDisconnect(socket,msg)
{
	var ip = GetClientIPAdress(socket);
	var rno = GetRoomNumberFromName(socket.namespace.name);
	$rooms.Get(rno).RemoveRom(ip);

	var romcount = $rooms.Get(rno).GetRomCount();
	socket.json.emit("send romcount",romcount);
	socket.json.broadcast.emit("send romcount",romcount);

	console.log("disconnected");
}

function ParseSetPassword(socket,msg)
{
	var rno = GetRoomNumberFromName(socket.namespace.name);
	var newMeg = {
		name:$system_name,
		message:null,
	};
	if($rooms.Get(rno).IsVolatile() == false && $rooms.Get(rno).SetPassword(msg.owner,msg.password))
		newMeg.message = resource.password_setted_message;
	else
		newMeg.message = resource.failed_set_password_message;
	ParseSendMsg(socket,newMeg);
}

function ParseJoin(socket,msg)
{
	var ip = GetClientIPAdress(socket);

	if(ipbanlist.IsBlockedToWrite(ip))
	{
		socket.emit("error",resource.block_message);
		return;
	}

	var rno = GetRoomNumberFromName(socket.namespace.name);

	$rooms.Get(rno).RemoveRom(ip);
	
	var romcount = $rooms.Get(rno).GetRomCount();
	socket.json.emit("send romcount",romcount);
	socket.json.broadcast.emit("send romcount",romcount);

	if($rooms.Get(rno).IsVolatile() == false)
	{
		if($rooms.Get(rno).IsTimeout() ||
			$rooms.Get(rno).IsFirstAuth())
		{
			$rooms.Get(rno).Reset(msg.name);
			ParseGetPastLog(socket,util.format($log_file_name,rno));
		}
		else if($rooms.Get(rno).Auth(msg.name,msg.password))
		{
			ParseGetPastLog(socket,util.format($log_file_name,rno));
		}
		else
		{
			socket.emit("error",resource.unmatch_password);
			return;
		}
	}

	var newMeg = {
		name:$system_name,
		message:util.format("/enteredby %s %s %s",msg.name,msg.color,msg.mailto),
	};
	ParseSendMsg(socket,newMeg);
}

function ParseQuit(socket,msg)
{
	var ip = GetClientIPAdress(socket);

	if(ipbanlist.IsBlockedToWrite(ip))
	{
		socket.emit("error",resource.block_message);
		return;
	}

	var rno = GetRoomNumberFromName(socket.namespace.name);

	var newMeg = {
		name:$system_name,
		message:resource.password_resetted_message,
	};

	$rooms.Get(rno).AddRom(ip);

	var romcount = $rooms.Get(rno).GetRomCount();
	socket.json.emit("send romcount",romcount);
	socket.json.broadcast.emit("send romcount",romcount);

	if($rooms.Get(rno).IsVolatile() == false)
	{
		if($rooms.Get(rno).IsOwner(msg.name))
		{
			$rooms.Get(rno).Reset(null);
			ParseSendMsg(socket,newMeg);
		}
		if(!$rooms.Get(rno).IsFirstAuth() &&
			!$rooms.Get(rno).IsAuthed(msg.name))
			return;
		else
			$rooms.Get(rno).RemoveAuth(msg.name);
	}

	newMeg.message = util.format("/quitedby %s",msg.name);
	ParseSendMsg(socket,newMeg);
}

//socket 接続中のソケット
//msg msgクラス
function ParseSendMsg(socket,msg)
{
	var ip = GetClientIPAdress(socket);

	if(ip in ipbanlist)
	{
		socket.emit("error",resource.block_message);
		return;
	}

	var rno = GetRoomNumberFromName(socket.namespace.name);

	if(msg.name != $system_name && 
		$rooms.Get(rno).IsVolatile() == false &&
		!$rooms.Get(rno).IsAuthed(msg.name) &&
		!$rooms.Get(rno).IsOwner(rno,msg.name))
	{
		return;
	}

	var date = new Date();

	var repacked_msg = CreateMessage(msg.name,date,msg.message);

	if(socket.handshake.admin)
		repacked_msg.ip = ip;

	socket.json.emit("req msg", repacked_msg);

	socket.json.broadcast.emit("req msg", repacked_msg);

	var path = $log_directory + "/" + util.format($log_file_name,rno);
	var log = new ChatLog(path);
	log.Save(repacked_msg,ip,rno);
}

function GetNameFromRoomNumber(number)
{
	return "/" + number;
}

function GetRoomNumberFromName(name)
{
	if(name.charAt(0) == "/")
		return parseInt(name.substr(1));
	throw "GetRoomNumberFromName error";
}

function ParseGetPastLog(socket,file)
{
	if(file == "")
		return;
	var path = $log_directory + "/" + file;
	var log = new ChatLog(path);
	log.ToArray(config.showip,function(array){
		socket.json.emit("req pastlog",array);
	});
}

function ChatLog(path)
{
	this.ToArray = function(hasIp,callback)
	{
		var state = fs.stat(path,function(err,state){
			if(err)
				return;
			var array = new Array();
			var stream = fs.createReadStream(path);
			new lazy(stream)
				.lines
				.forEach(function(line){
					var msg = CreateMessageFromText(line.toString());
					if(hasIp == false)
						msg.ip = "";
					array.push(msg);
				})
				.join(function(){
					callback(array);
				});
		});
	}

	this.Save = function(msg,ip,rno){
		var text = GetTextFromMessage(msg,ip);

		SplitLog(rno,function(){
			WritePastLog(path,text);
		});
	};

	function GetTextFromMessage(msg,ip)
	{
		var text = msg.name + "<>" +
				msg.date + "<>" +
				ip + "<>" +
				msg.message +
				"\n";
		return text;
	}

	function SplitLog(rno,callback)
	{
		var state = fs.stat(path,function(err,state){
			if(err && typeof(callback) == "function")
			{
				callback();
				return;
			}
			if(state.size > $spilt_size)
			{
				var date = new Date();
				var dateString = ""+date.getFullYear()+date.getMonth()+date.getDate()+date.getHours()+date.getMinutes()+date.getSeconds();

				var newpath = $log_directory + "/" +
					util.format($splited_log_file_name,rno,dateString);
				fs.rename(path,newpath,callback);
			}else{
				if(typeof(callback) == "function")
					callback();
			}
		});
	}

	function WritePastLog(path,text)
	{
		async.waterfall([
			function(callback){
				fs.open(path,"a",callback);
			},
			function(fd,callback){
				var buf = new Buffer(text);
				fs.write(fd,buf,0,Buffer.byteLength(text),null,function(){
					callback(null,fd);
				});
			},
			function(fd){
				fs.close(fd);
			}
		]);
	}
}

function GetClientIPAdress(socket)
{
	return socket.handshake.headers["x-forwarded-for"] || socket.handshake.address.address;
}

// Message クラス
function CreateMessage(name,date,message)
{
	var result = {name:name,
		date:date,
		ip:"",
		message:message};
	return result;
}
function CreateMessageFromText(text)
{
	var data = text.split("<>");
	var msg = {name:data[0],
		ip:data[2],
		date:data[1],
		message:data[3]};
	return msg;
}
