/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.logging;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.itscool.commons.logging.AbstractLog;
import org.itscool.commons.logging.CallClass;
import org.itscool.commons.logging.LogRuntimeException;

public class SimpleLog
extends AbstractLog {
    private static SimpleLog log = null;
    static /* synthetic */ Class class$0;

    public void debug(String msg) {
        this.out(msg, "debug", 3);
    }

    public void info(String msg) {
        this.out(msg, "info", 3);
    }

    public void warn(String msg) {
        this.out(msg, "warn", 3);
    }

    public void error(String msg) {
        this.out(msg, "error", 3);
    }

    public void fatal(String msg) {
        this.out(msg, "fatal", 3);
    }

    public void debug(Exception msg) {
        this.out(msg, "debug");
    }

    public void info(Exception msg) {
        this.out(msg, "info");
    }

    public void warn(Exception msg) {
        this.out(msg, "warn");
    }

    public void error(Exception msg) {
        this.out(msg, "error");
    }

    public void fatal(Exception msg) {
        this.out(msg, "fatal");
    }

    public void debug(Error msg) {
        this.out(msg, "debug");
    }

    public void info(Error msg) {
        this.out(msg, "info");
    }

    public void warn(Error msg) {
        this.out(msg, "warn");
    }

    public void error(Error msg) {
        this.out(msg, "error");
    }

    public void fatal(Error msg) {
        this.out(msg, "fatal");
    }

    public boolean isOutputClass(String clazzName) {
        boolean ret = false;
        int size = this.outputClasses.size();
        if (size == 0) {
            return true;
        }
        int i = 0;
        while (i < size) {
            String pattern = (String)this.outputClasses.get(i);
            if (clazzName.indexOf(pattern) == 0) {
                return true;
            }
            ++i;
        }
        return ret;
    }

    public static synchronized AbstractLog getInstance() {
        if (log == null) {
            log = new SimpleLog();
        }
        return log;
    }

    protected synchronized void out(String logMsg, String levelNow, int classLevel) {
        CallClass call = new CallClass(classLevel);
        String clazz = call.getClassName();
        String func = call.getMethodName();
        int line = call.getLineNumber();
        if (!this.isOutputClass(clazz)) {
            return;
        }
        if (this.levelInt > this.getLevelNum(levelNow)) {
            return;
        }
        try {
            if (this.mode.equals("file")) {
                this.outFile(clazz, func, logMsg, levelNow, line);
            } else if (this.mode.equals("disp")) {
                SimpleLog.outDisp(clazz, func, logMsg, levelNow, line);
            } else if (this.mode.equals("all")) {
                this.outFile(clazz, func, logMsg, levelNow, line);
                SimpleLog.outDisp(clazz, func, logMsg, levelNow, line);
            } else {
                SimpleLog.outDisp(clazz, func, logMsg, levelNow, line);
            }
        }
        catch (IOException ioe) {
            throw new LogRuntimeException(ioe.getMessage());
        }
    }

    protected synchronized void out(Exception e, String levelNow) {
        if (e.getMessage() == null) {
            log.out(e.getClass().getName(), levelNow, 4);
        } else {
            log.out(e.getMessage(), levelNow, 4);
        }
        StackTraceElement[] traceList = e.getStackTrace();
        int i = 0;
        while (i < traceList.length) {
            StackTraceElement trace = traceList[i];
            this.out(trace.toString(), levelNow, 4);
            ++i;
        }
    }

    protected synchronized void out(Error e, String levelNow) {
        if (e.getMessage() == null) {
            log.out(e.getClass().getName(), levelNow, 4);
        } else {
            log.out(e.getMessage(), levelNow, 4);
        }
        StackTraceElement[] traceList = e.getStackTrace();
        int i = 0;
        while (i < traceList.length) {
            StackTraceElement trace = traceList[i];
            this.out(trace.toString(), levelNow, 4);
            ++i;
        }
    }

    protected void outFile(String clazz, String func, String logMsg, String levelNow, int line) throws IOException {
        if (this.maxSize <= 0) {
            SimpleLog.outDisp(clazz, func, logMsg, levelNow, line);
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.itscool.commons.logging.SimpleLog");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            SimpleLog.outDisp(clazz2.getName(), "outFile()", "\u30d5\u30a1\u30a4\u30eb\u306e\u51fa\u529b\u30b5\u30a4\u30ba\u304c\uff10\u3067\u3059", "error", line);
            return;
        }
        this.sizeCheck();
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(this.logPath, true), this.encode);
        w.write(SimpleLog.getMsg(clazz, func, logMsg, levelNow, line));
        ((Writer)w).close();
    }

    protected static void outDisp(String clazz, String func, String logMsg, String levelNow, int line) {
        System.out.print(SimpleLog.getMsg(clazz, func, logMsg, levelNow, line));
    }

    protected static String getMsg(String clazz, String func, String logMsg, String levelNow, int line) {
        StringBuffer log = new StringBuffer();
        log.append(SimpleLog.getNowDate());
        log.append(" ").append(SimpleLog.getLogKind(levelNow));
        log.append(" ").append(clazz);
        log.append(" ").append(func);
        log.append("(line=").append(line).append(")");
        log.append(" (").append(logMsg).append(")");
        log.append(System.getProperty("line.separator"));
        return log.toString();
    }
}

