/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.request;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.itscool.commons.request.GeneralForm;
import org.itscool.commons.request.HttpGeneralForm;
import org.itscool.commons.request.MultiHttpGeneralForm;
import org.itscool.commons.request.SimpleHttpGeneralForm;

public class GeneralFormFactory {
    private static GeneralFormFactory factory = null;

    private GeneralFormFactory() {
    }

    public static GeneralFormFactory getInstance() {
        if (factory == null) {
            factory = new GeneralFormFactory();
        }
        return factory;
    }

    public GeneralForm create(HttpServletRequest req, String encode) throws IOException {
        HttpGeneralForm generalForm = null;
        String type = req.getHeader("content-type");
        if (type != null && type.toLowerCase().indexOf("multipart") != -1) {
            generalForm = new MultiHttpGeneralForm();
            generalForm.parseData(req, encode);
        } else {
            generalForm = new SimpleHttpGeneralForm();
            generalForm.parseData(req, encode);
        }
        return generalForm;
    }
}

