/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.weber.io;

import java.io.IOException;
import java.util.LinkedList;
import org.itscool.commons.document.XmlConfigReader;
import org.itscool.weber.mapping.ExceptionMapping;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExceptionConfigReader
extends XmlConfigReader {
    protected void doCreate(LinkedList hashMap) throws IOException {
        Node exception;
        Element root = this.document.getDocumentElement();
        if (root == null) {
            String err = "Can not root element at itscool-config.xml(" + ((Object)((Object)this)).getClass().getName() + ")";
            throw new IOException(err);
        }
        NodeList exceptionList = root.getElementsByTagName("global-exceptions");
        if (exceptionList != null && (exception = exceptionList.item(0)) != null) {
            this.createExceptions(exception, hashMap);
        }
    }

    protected void createExceptions(Node exceptions, LinkedList hashMap) {
        NodeList exceptionsChilds = exceptions.getChildNodes();
        int i = 0;
        while (i < exceptionsChilds.getLength()) {
            Node exception = exceptionsChilds.item(i);
            if (exception.getNodeName().equals("exception")) {
                this.createException(exception, hashMap);
            }
            ++i;
        }
    }

    protected void createException(Node exception, LinkedList hashMap) {
        NamedNodeMap attributes = exception.getAttributes();
        Node path = attributes.getNamedItem("path");
        Node name = attributes.getNamedItem("name");
        if (path == null || name == null) {
            return;
        }
        ExceptionMapping mapping = new ExceptionMapping(path.getNodeValue(), name.getNodeValue());
        hashMap.addFirst(mapping);
    }
}

