/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.stylist.io;

import java.io.IOException;
import java.util.LinkedList;
import org.itscool.commons.document.XmlConfigReader;
import org.itscool.stylist.mapping.LayoutMapping;
import org.itscool.stylist.mapping.LayoutPutMapping;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LayoutConfigReader
extends XmlConfigReader {
    protected void doCreate(LinkedList hashMap) throws IOException {
        Element root = this.document.getDocumentElement();
        if (root == null) {
            String err = "Can not root element at stylist-config.xml(" + ((Object)((Object)this)).getClass().getName() + ")";
            throw new IOException(err);
        }
        NodeList includeList = root.getElementsByTagName("layout-mappings");
        if (includeList == null) {
            String err = "Can not element at <layout-mappings>(" + ((Object)((Object)this)).getClass().getName() + ")";
            throw new IOException(err);
        }
        Node include = includeList.item(0);
        if (include != null) {
            this.createIncludes(include, hashMap);
        }
    }

    protected void createIncludes(Node includes, LinkedList hashMap) {
        NodeList includesChilds = includes.getChildNodes();
        int i = 0;
        while (i < includesChilds.getLength()) {
            Node include = includesChilds.item(i);
            if (include.getNodeName().equals("layout")) {
                this.createInclude(include, hashMap);
            }
            ++i;
        }
    }

    protected void createInclude(Node include, LinkedList hashMap) {
        NamedNodeMap attributes = include.getAttributes();
        Node path = attributes.getNamedItem("path");
        Node name = attributes.getNamedItem("name");
        Node extendz = attributes.getNamedItem("extends");
        LayoutMapping includeMapping = new LayoutMapping(name.getNodeValue());
        includeMapping.setPath(path.getNodeValue());
        if (extendz != null) {
            includeMapping.setExtendz(extendz.getNodeValue());
        }
        NodeList includeChilds = include.getChildNodes();
        int i = 0;
        while (i < includeChilds.getLength()) {
            Node put = includeChilds.item(i);
            if (put.getNodeName().equals("put")) {
                this.createPut(put, includeMapping);
            }
            ++i;
        }
        hashMap.addFirst(includeMapping);
    }

    protected void createPut(Node put, LayoutMapping includeMapping) {
        NamedNodeMap attributes = put.getAttributes();
        Node path = attributes.getNamedItem("path");
        Node name = attributes.getNamedItem("name");
        LayoutPutMapping putMapping = new LayoutPutMapping(name.getNodeValue(), path.getNodeValue());
        includeMapping.addPut(name.getNodeValue(), putMapping);
    }
}

