/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.request;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.logging.AbstractLog;
import org.itscool.commons.logging.SimpleLog;
import org.itscool.commons.request.GeneralForm;
import org.itscool.commons.request.HttpGeneralForm;
import org.itscool.commons.request.MultiHttpGeneralForm;
import org.itscool.commons.request.SimpleHttpGeneralForm;

public class GeneralFormFactory {
    private static GeneralFormFactory factory = null;
    protected static AbstractLog log;

    private GeneralFormFactory() {
        BeanFactory factory = BeanFactory.getInstance();
        try {
            log = (AbstractLog)factory.getInstance("Log");
            if (!log.isInit()) {
                log = (AbstractLog)factory.createInstance("Log");
            }
        }
        catch (Exception ioe) {
            log = SimpleLog.getInstance();
            log.info(ioe.getMessage());
        }
    }

    public static GeneralFormFactory getInstance() {
        if (factory == null) {
            factory = new GeneralFormFactory();
        }
        return factory;
    }

    public GeneralForm create(HttpServletRequest req, String encode) throws IOException {
        HttpGeneralForm generalForm = null;
        String type = req.getHeader("content-type");
        if (type != null && type.toLowerCase().indexOf("multipart") != -1) {
            generalForm = new MultiHttpGeneralForm();
            this.parseData(generalForm, req, encode);
        } else {
            generalForm = new SimpleHttpGeneralForm();
            this.parseData(generalForm, req, encode);
        }
        return generalForm;
    }

    public void parseData(HttpGeneralForm generalForm, HttpServletRequest req, String encode) throws IOException {
        String methodType = req.getMethod();
        log.trace("mothod type=" + methodType);
        try {
            req.setCharacterEncoding(encode);
        }
        catch (UnsupportedEncodingException uee) {
            throw new IOException(uee);
        }
        if (methodType.equals("POST")) {
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            DataInputStream dis = new DataInputStream((InputStream)req.getInputStream());
            boolean flag = true;
            while (flag) {
                try {
                    byte b = dis.readByte();
                    bao.write(b);
                }
                catch (EOFException e) {
                    flag = false;
                }
            }
            if (bao.size() > 0) {
                generalForm.doParseData(bao.toByteArray(), encode);
            } else {
                generalForm.doDefaultParseData(req, encode);
            }
        } else {
            generalForm.doDefaultParseData(req, encode);
        }
    }
}

