/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.weber.controller;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.logging.AbstractLog;
import org.itscool.commons.logging.SimpleLog;
import org.itscool.weber.user.User;

public class FrontServletListener
implements HttpSessionListener,
HttpSessionAttributeListener {
    protected AbstractLog log;

    public void sessionCreated(HttpSessionEvent hse) {
        HttpSession session = hse.getSession();
        String id = session.getId();
        this.log.trace("Session created id=" + id);
    }

    public void sessionDestroyed(HttpSessionEvent hse) {
        HttpSession session = hse.getSession();
        String id = session.getId();
        this.log.trace("Session destroyed id=" + id);
    }

    public void attributeAdded(HttpSessionBindingEvent event) {
        HttpSession session = event.getSession();
        String id = session.getId();
        if (event.getValue() instanceof User) {
            this.log.trace("login one user id=" + id);
        }
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
        HttpSession session = event.getSession();
        String id = session.getId();
        if (event.getValue() instanceof User) {
            this.log.trace("login one user id=" + id);
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
        HttpSession session = event.getSession();
        String id = session.getId();
        if (event.getValue() instanceof User) {
            this.log.trace("logout one user id=" + id);
        }
    }

    public FrontServletListener() {
        BeanFactory factory = BeanFactory.getInstance();
        if (!factory.isInit()) {
            try {
                factory.createForUrl("di-config.xml");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex.getMessage());
            }
        }
        try {
            if (factory.isDefined("Log")) {
                this.log = (AbstractLog)factory.getInstance("Log");
                if (!this.log.isInit()) {
                    this.log = (AbstractLog)factory.createInstance("Log");
                }
            } else {
                this.log = SimpleLog.getInstance();
            }
        }
        catch (Exception ioe) {
            throw new RuntimeException(ioe.getMessage());
        }
        this.log.trace("started");
    }
}

