/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.itscool.commons.util.FileUtilException;

public class FileUtil {
    public static void copy(String from, String to) {
        try {
            int data;
            File file = new File(from);
            if (file.isDirectory()) {
                return;
            }
            BufferedInputStream fr = new BufferedInputStream(new FileInputStream(from));
            BufferedOutputStream fw = new BufferedOutputStream(new FileOutputStream(to));
            while ((data = ((InputStream)fr).read()) != -1) {
                ((OutputStream)fw).write(data);
            }
            ((OutputStream)fw).close();
            File fromFile = new File(from);
            File toFile = new File(to);
            toFile.setLastModified(fromFile.lastModified());
        }
        catch (IOException ex) {
            throw new FileUtilException(ex.getMessage());
        }
    }

    public static boolean copyAll(String fromDir, String toDir) {
        boolean ret = true;
        File file = new File(toDir);
        if (!file.isDirectory()) {
            file.mkdirs();
        }
        String[] list = FileUtil.getFileList(fromDir);
        for (int i = 0; i < list.length; ++i) {
            try {
                FileUtil.copy(fromDir + "/" + list[i], toDir + "/" + list[i]);
                continue;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                ret = false;
            }
        }
        return ret;
    }

    public static String[] getFileList(String path) {
        String[] list = new String[]{};
        File file = new File(path);
        if (!file.isDirectory()) {
            return list;
        }
        return file.list();
    }

    public static void delete(String fileName) {
        try {
            File file = new File(fileName);
            if (file.isDirectory()) {
                return;
            }
            if (!file.delete()) {
                throw new FileUtilException("delete failed [" + fileName + "]");
            }
        }
        catch (Exception ex) {
            throw new FileUtilException(ex.getMessage());
        }
    }

    public static boolean deleteAll(String dir) {
        boolean ret = true;
        File file = new File(dir);
        if (!file.isDirectory()) {
            throw new FileUtilException("directory not found [" + dir + "]");
        }
        String[] list = FileUtil.getFileList(dir);
        for (int i = 0; i < list.length; ++i) {
            try {
                FileUtil.delete(dir + "/" + list[i]);
                continue;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                ret = false;
            }
        }
        return ret;
    }

    public static long getLastModified(String path) {
        File file = new File(path);
        if (file.isFile()) {
            long lastModified = file.lastModified();
            return lastModified;
        }
        return 0L;
    }

    public static boolean isFile(String path) {
        if (path == null || path.length() == 0) {
            return false;
        }
        File file = new File(path);
        return file != null && file.isFile();
    }
}

