/* $Id$ */

drop table if exists syslog;
create table syslog(
	id int AUTO_INCREMENT PRIMARY KEY,
	last_modified timestamp NOT NULL,
	log varchar(255) NOT NULL,
	agent varchar(64) NOT NULL
) type=InnoDB;

/* dummy trac wiki table */
drop table if exists wiki;
create table wiki(
	name varchar(255) NOT NULL,
	version int NOT NULL,
	time int NOT NULL,
	author varchar(64),
	ipnr varchar(64),
	text text,
	comment text,
	readonly int NOT NULL,
	constraint wiki_pk primary key (
    	name,
    	version
  	)
) type=InnoDB;

/* dummy trac ticket table */
drop table if exists ticket;
create table ticket(
	id int primary key,
	type varchar(64),
	time int NOT NULL,
	changetime int NOT NULL,
	component varchar(64),
	severity varchar(64),
	priority varchar(64),
	owner varchar(64),
	reporter varchar(64),
	cc varchar(64),
	version varchar(64),
	milestone varchar(64),
	status varchar(64),
	resolution varchar(64),
	summary varchar(255),
	description text,
	keywords varchar(255)
) type=InnoDB;
