#!/usr/bin/perl -w

#
# MySQL Heart Beat Check Command
#
# Copyright 2006 Yomei Komiya
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
# 	http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

use strict;
use DBI;
use Getopt::Std;

my $opt = {}; 
getopts('hu:p:H:w:c:', $opt);

if ($opt->{'h'}) {
	print <<FOO;
check_mysql_heartbeat (nagios-plugins 1.3) 1.0
Copyright (c) 2006 Yomei Komiya

 check replication delay on MySQL slave server

 Usage:
  check_mysql_heartbeat.pl [ -H <slave host> ]
                           [ -u <user>] [-p <password>]
                           [ -w <delay> ] [ -c <delay> ] 

 Options:
  -H <slave host>    - a slave server (default: localhost)
  -u <user>          - Database access user (default: nagios)
  -p <password>      - Database access password (default: none)
  -w <delay>         - Warning replication delay (default: 60)
  -c <delay>         - Critical replication delay (default: 90)
  -help              - This help page
FOO
	exit;
}

if (! $opt->{'H'}) {
	$opt->{'H'} = 'localhost';
}
if (! $opt->{'u'}) {
	$opt->{'u'} = 'nagios';
}
if (! $opt->{'p'}) {
	$opt->{'p'} = '';
}
if (! $opt->{'w'}) {
	$opt->{'w'} = 60;
}
if (! $opt->{'c'}) {
	$opt->{'c'} = 90;
}

my $conn = DBI->connect(
	"DBI:mysql:mysql_mon:$opt->{'H'}",
	$opt->{'u'},
	$opt->{'p'}
) or die;

my $sql = $conn->prepare(
	"select unix_time, db_time from heartbeat
	 order by unix_time desc limit 1");

$sql->execute;
my $num_rows = $sql->rows;
my @info;
for (my $i = 0; $i < $num_rows; $i++) {
	@info = $sql->fetchrow_array;
}

my $time = $info[0];
my $delay = time() - $time;
my $state = "slave is $delay seconds behind"; 

$sql->finish;
$conn->disconnect;

if ($delay >= $opt->{'c'}) {
	print "CRITICAL: $state\n";
	exit 2;
}
elsif ($delay >= $opt->{'w'}) {
	print "WARN: $state\n";
	exit 1;
}
else {
	print "OK: $state\n";
	exit 0;
}
