/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.compass;

import java.rmi.RemoteException;

import jp.sourceforge.webframe.ws.search.Result;
import jp.sourceforge.webframe.ws.search.SearchWebService;

/**
 * DistributedIndexSearcher
 *
 * @author Yomei Komiya
 *
 * @deprecated Use jp.sourceforge.metasearch.compass.DistributedIndexSearcher
 *		of <a href="http://metasearch.sourceforge.jp/">MetaSearch project</a>
 * @version $Id$
 */
public class DistributedIndexSearcher {

	/**
	 * Search Web Services
	 * injected by Spring
	 */
	private SearchWebService[] searchWebServices = null;
	
	
	public DistributedIndexSearcher() {
		super();
	}

	
	public final void setSearchWebServices(
			SearchWebService[] searchWebServices) {
		this.searchWebServices = searchWebServices;
	}


	/**
	 * Find Documents by Multiple Search Web Service
	 * 
	 * @param query Query String
	 * @return Search Result List
	 * @throws SearchFailedException
	 */
	public SearchResult[] find(String query) throws SearchFailedException {

		return this.find(query, 10, 0);
	}

	
	/**
	 * Find Documents
	 * 
	 * @param query Query String
	 * @param num Display Number per Page
	 * @param start Display Start Position
	 * @return Search Result List
	 * @throws SearchFailedException
	 */
	public SearchResult[] find(String query, int num, int start)
		throws SearchFailedException {
		
		SearchResult[] searchResults
			= new SearchResult[this.searchWebServices.length]; 
		for (int i = 0; i < this.searchWebServices.length; i++) {
			try {
				Result result = searchWebServices[i].seek(query, num, start);
				searchResults[i] = new SearchResult(result);
			}
			catch (RemoteException re) {
				re.printStackTrace();
			}
		}
	
		return searchResults;
	}
	
}
