/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.example.main.servlet.filter;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.TransactionException;

import jp.sourceforge.webframe.example.main.dao.SysLogDao;
import jp.sourceforge.webframe.example.main.entity.SysLogBean;

/**
 * RequestStatisticsFilter
 *
 * @author Yomei Komiya
 *
 * $Id$
 */
public class RequestStatisticsFilter implements Filter {
	
	/**
	 * log4j logger
	 */
	static Logger logger = Logger.getLogger(RequestStatisticsFilter.class);
	
	/**
	 * SysLogDao object is injected by Spring
	 * ref. WEB-INF/spring/applicationContext.xml
	 */
	private SysLogDao sysLogDao = null;


	public void setSysLogDao(SysLogDao sysLogDao) {
		this.sysLogDao = sysLogDao;
	}

	
	/*?
	 * @see javax.servlet.Filter#init(javax.servlet.FilterConfig)
	 */
	public void init(FilterConfig config) throws ServletException {
		// do nothing.
	}

	
	/*?
	 * @see javax.servlet.Filter#doFilter(javax.servlet.ServletRequest, javax.servlet.ServletResponse, javax.servlet.FilterChain)
	 */
	public void doFilter(
					ServletRequest request,
					ServletResponse response,
					FilterChain chain)
		throws IOException, ServletException 
	{
		try {
			String log = "";
			log = request.getRemoteHost()
				+ "(" + request.getRemoteAddr()
				+ ":" + request.getRemotePort() + ")";
			logger.info(log);
			
			SysLogBean sysLog = new SysLogBean(log, "RequestStatisticsFilter");
			sysLogDao.insertLog(sysLog);
		}
		catch (DataAccessException dae) {
			dae.printStackTrace();
			logger.error(dae);
		}
		catch (TransactionException txe) {
			txe.printStackTrace();
			logger.error(txe);
		}
		finally {
			chain.doFilter(request, response);
		}
	}

	
	/*
	 * @see javax.servlet.Filter#destroy()
	 */
	public void destroy() {
		// do nothing.
	}

}
