/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.ws.search;

import java.util.Iterator;

import jp.sourceforge.webframe.compass.SearchResult;
import jp.sourceforge.webframe.compass.entity.Searchable;

/**
 * Result
 *
 * @author Yomei Komiya
 *
 * @deprecated Use jp.sourceforge.metasearch.ws.Result
 *		of <a href="http://metasearch.sourceforge.jp/">MetaSearch project</a>
 * @version $Id$
 */
public class Result {

	/**
	 * Search Provider
	 */
	private String provider = "";
	
	/**
	 * Search Provider URL
	 */
	private String providerUrl = "";

	/**
	 * Query String
	 */
	private String query = "";
	
	/**
	 * Current Query for Search Refinement
	 */
	private String currentQuery = "";
	
	/**
	 * Total Hit Numbers
	 */
	private int totalNum = 0;
	
	/**
	 * Display Number per Page
	 */
	private int num = 10;
	
	/**
	 * Display Start Position
	 */
	private int start = 0;
	
	/**
	 * Search Time (millisecond)
	 */
	private long searchTime = 0;

	/**
	 * Hit Document List
	 */
	private Hit[] hits = null;
	
	
	/**
	 * Default Constructor
	 */
	public Result() {
		super();
	}


	/**
	 * Constructor
	 * 
	 * @param searchResult
	 */
	public Result(SearchResult searchResult) {
		super();
		
		this.provider = searchResult.getProvider();
		this.providerUrl = searchResult.getProviderUrl();
		this.query = searchResult.getQuery();
		this.currentQuery = searchResult.getCurrentQuery();
		this.totalNum = searchResult.getTotalNum();
		this.num = searchResult.getNum();
		this.start = searchResult.getStart();
		this.searchTime = searchResult.getSearchTime();

		this.hits = new Hit[searchResult.getList().size()];
		int i = 0;
		for (Iterator ite = searchResult.getList().iterator();
			ite.hasNext();
			i++) {
			Searchable searchable = (Searchable)ite.next();
			hits[i] = new Hit(searchable);
		}
	}

	
	public final String getProvider() {
		return provider;
	}


	public final void setProvider(String provider) {
		this.provider = provider;
	}


	public final String getProviderUrl() {
		return providerUrl;
	}


	public final void setProviderUrl(String providerUrl) {
		this.providerUrl = providerUrl;
	}


	public final String getQuery() {
		return query;
	}


	public final String getCurrentQuery() {
		return currentQuery;
	}


	public final void setCurrentQuery(String currentQuery) {
		this.currentQuery = currentQuery;
	}


	public final void setQuery(String query) {
		this.query = query;
	}


	public final int getNum() {
		return num;
	}


	public final void setNum(int num) {
		this.num = num;
	}


	public final Hit[] getHits() {
		return hits;
	}


	public final void setHits(Hit[] hits) {
		this.hits = hits;
	}


	public final int getStart() {
		return start;
	}


	public final void setStart(int start) {
		this.start = start;
	}


	public final int getTotalNum() {
		return totalNum;
	}


	public final void setTotalNum(int totalNum) {
		this.totalNum = totalNum;
	}


	public final long getSearchTime() {
		return searchTime;
	}


	public final void setSearchTime(long searchTime) {
		this.searchTime = searchTime;
	}
	
}
