/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.compass.entity;

import java.io.File;
import java.net.URL;
import java.util.Date;

import junit.framework.TestCase;

/**
 * GenericTextFileEntityTest
 *
 * @author Yomei Komiya
 *
 * $Id$
 */
public class GenericTextFileEntityTest extends TestCase {

	private GenericTextFileEntity genericTextFileEntity = null;
	
	
	protected void setUp() throws Exception {
		super.setUp();
		
		this.genericTextFileEntity = new GenericTextFileEntityMock();
	}

	
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	
	/*
	 * 'jp.sourceforge.webframe.compass.entity.GenericTextFileEntity.loadFile(File, String, int)' test method
	 */
	public void testLoadFile() {
		URL fileUrl = this.getClass().getResource("/testdata/TextFileSample.txt");
		File file = new File(fileUrl.getPath());
		String encoding = "UTF8";

		int maxSize = 10;
		this.genericTextFileEntity.loadFile(file, encoding, maxSize);
		
		assertEquals(
				file.getAbsolutePath(),
				this.genericTextFileEntity.getLocalIdentifier());
		assertEquals(
				new Date(file.lastModified()),
				this.genericTextFileEntity.getDate());
		assertEquals(file.getName(), this.genericTextFileEntity.getTitle());
		assertEquals(file.length(), this.genericTextFileEntity.getSize());
		assertEquals(10, this.genericTextFileEntity.getContent().length());
		
		maxSize = 1024;
		this.genericTextFileEntity.loadFile(file, encoding, maxSize);
		
		assertEquals(
				"1234567890\nテキストファイルのサンプルです。\n2行目。\n",
				this.genericTextFileEntity.getContent()); 
	}

}
