/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.compass.entity;

import junit.framework.TestCase;

/**
 * TracWikiBeanTest
 *
 * @author Yomei Komiya
 *
 * $Id$
 */
public class TracWikiBeanTest extends TestCase {
	
	private TracWikiBean tracWikiBean;

	
	protected void setUp() throws Exception {
		super.setUp();
		
		tracWikiBean = new TracWikiBeanMock();
	}

	
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	
	/*
	 * 'jp.sourceforge.webframe.compass.entity.TracWikiBean.buildIdentifier()' test method
	 */
	public void testBuildIdentifier() {
		String resourceContext = "http://localhost/trac/home/wiki/";
		String localIdentifier = "テスト";
		this.tracWikiBean.setResourceContext(resourceContext);
		this.tracWikiBean.setLocalIdentifier(localIdentifier);
		this.tracWikiBean.buildIdentifier();

		assertEquals(
				resourceContext + "%E3%83%86%E3%82%B9%E3%83%88",
				this.tracWikiBean.getIdentifier());

		localIdentifier = "TestPage";
		this.tracWikiBean.setLocalIdentifier(localIdentifier);
		this.tracWikiBean.buildIdentifier();

		assertEquals(
				resourceContext + localIdentifier,
				this.tracWikiBean.getIdentifier());
	}

}
