/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.example.main.entity;

import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

import jp.sourceforge.webframe.compass.entity.SearchableMetaDataEntity;

/**
 * SysLogBean syslog entity
 *
 * @author Yomei Komiya
 * 
 * $Id: SysLogBean.java 6 2007-06-27 13:49:06Z whitestar $
 */
public class SysLogBean extends SearchableMetaDataEntity {
	
	private String id;

	private Date lastModified;

	private String log;
	
	private String agent;

	
	public SysLogBean() {
		super();
	}

		
	public SysLogBean(String log, String agent) {
		super();
		this.log = log;
		this.agent = agent;
	}


	public String getId() {
		return id;
	}

	
	public void setId(String id) {
		this.id = id;
	}

	
	public String getLocalIdentifier() {
		return id;
	}

	
	public void setLocalIdentifier(String localIdentifier) {
		this.id = localIdentifier;
	}

	
	public Date getLastModified() {
		return lastModified;
	}


	public void setLastModified(Date lastModified) {
		this.lastModified = lastModified;
	}


	public Date getDate() {
		return lastModified;
	}

	
	public void setDate(Date date) {
		this.lastModified = date;
	}

	
	public String getLog() {
		return log;
	}

	
	public void setLog(String log) {
		this.log = log;
	}


	public String getAgent() {
		return agent;
	}


	public void setAgent(String agent) {
		this.agent = agent;
	}


	/* for Searchable */
	public String getTitle() {
		return this.lastModified.toString();
	}

	
	public void setTitle(String title) {
	}


	public String getContent() {
		return this.log;
	}
	
	
	public void setContent(String content) {
		this.log = content;
	}


	public String getCreator() {
		return this.agent;
	}
	
	
	public void setCreator(String creator) {
		this.agent = creator;
	}

	
	public void buildIdentifier() {
		this.setIdentifier(this.getResourceContext() + "/" + this.id);
	}


	public String toString() {
		String str = new ToStringBuilder(this)
			.append("id", id)
			.append("last modified", lastModified)
			.append("log", log)
			.append("agent", agent)
			.toString();
		str += " < " + super.toString();

		return str;
	}
	
}
