/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.springframework.compass;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.Compass;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfiguration;

/**
 * CompassFactory
 *
 * @author Yomei Komiya
 *
 * $Id: CompassFactory.java 6 2007-06-27 13:49:06Z whitestar $
 */
public class CompassFactory {
	
	protected final Log logger = LogFactory.getLog(getClass());

	/**
	 * Sen Home Directory Path
	 * injected by Spring
	 */
	private String senHome = null;
	
	/**
	 * Compass Configuration Location from classpath
	 * injected by Spring
	 */
	private String configLocation = "";
	
	
	public CompassFactory() {
		super();
	}

	
	public void setConfigLocation(String configLocation) {
		this.configLocation = configLocation;
	}
	

	public void setSenHome(String senHome) {
		this.senHome = senHome;
	}


	public Compass createCompass() throws CompassException {
		if (this.senHome != null) {
			System.setProperty("sen.home", this.senHome);
		}
			
		try {
			CompassConfiguration config = new CompassConfiguration();
			config.configure(this.configLocation);

			return config.buildCompass();
		}
		catch (CompassException ce) {
			throw ce;
		}
		catch (RuntimeException re) {
			throw re;
		}
		catch (Exception e) {
			logger.error("Why does Compass throw a generic checked exception, after all?", e);
			throw new CompassException(e.getMessage());
		}
	}
	
}
