/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2007 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.struts.util;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;

import org.apache.commons.collections.map.TypedMap;
import org.apache.struts.Globals;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.tiles.ComponentDefinition;
import org.apache.struts.tiles.DefinitionsFactory;
import org.apache.struts.tiles.DefinitionsFactoryConfig;
import org.apache.struts.tiles.DefinitionsFactoryException;
import org.apache.struts.tiles.FactoryNotFoundException;
import org.apache.struts.tiles.NoSuchDefinitionException;
import org.apache.struts.tiles.TilesUtilImpl;

/**
 * StrutsUtils
 *
 * @author Yomei Komiya
 * @since 0.9.2
 *
 * @version $Id: StrutsUtils.java 6 2007-06-27 13:49:06Z whitestar $
 */
public class StrutsUtils {

	public StrutsUtils() {
		super();
	}
	
	
	/**
	 * Get ModuleConfig map
	 * 
	 * @param action Action object
	 * @return ModuleConfig map<String prefix, ModuleConfig config>
	 */
	static public Map getModuleConfigs(Action action) {
		return getModuleConfigs(action.getServlet());
	}
	
	
	/**
	 * Get ModuleConfig map
	 * 
	 * @param servlet ActionServlet object
	 * @return ModuleConfig map<String prefix, ModuleConfig config>
	 */
	static public Map getModuleConfigs(ActionServlet servlet) {
		Map moduleConfigs = TypedMap.decorate(
				new HashMap(), String.class, ModuleConfig.class);
		
		// Default module config
		moduleConfigs.put("", StrutsUtils.getModuleConfig("", servlet));
		
		Enumeration names = servlet.getInitParameterNames();
		while (names.hasMoreElements()) {
			String name = (String)names.nextElement();
			// Sub module config
			if (name.startsWith("config/")) {
				String prefix = name.substring(6);
				moduleConfigs.put(
						prefix,
						StrutsUtils.getModuleConfig(prefix, servlet));
			}
			else {
				continue;
			}
		}
		
		return moduleConfigs;
	}


	/**
	 * Get ModuleConfig object
	 * 
	 * @param prefix Module prefix
	 * @param action Action object
	 * @return ModuleConfig object
	 */
	public static ModuleConfig getModuleConfig(
			String prefix, Action action) {

		return StrutsUtils.getModuleConfig(prefix, action.getServlet());
	}

	
	/**
	 * Get ModuleConfig object
	 * 
	 * @param prefix Module prefix
	 * @param servlet ActionServlet object
	 * @return ModuleConfig object
	 */
	public static ModuleConfig getModuleConfig(
			String prefix, ActionServlet servlet) {
		
		ServletContext context = servlet.getServletContext();
		return (ModuleConfig)context.getAttribute(Globals.MODULE_KEY + prefix);
	}
	
	
	/**
	 * Get TilesDefinitionFactory object
	 * 
	 * @param prefix Module prefix
	 * @param action Action object
	 * @param request ServletRequest object
	 * @return DefinitionsFactory object
	 * @throws FactoryNotFoundException
	 */
	public static DefinitionsFactory getTilesDefinitionsFactory(
			String prefix,
			Action action,
			ServletRequest request) 
		throws FactoryNotFoundException {
		
		ServletContext context = action.getServlet().getServletContext();
		DefinitionsFactory definitionsFactory = null;
		definitionsFactory = (DefinitionsFactory)context.getAttribute(
				TilesUtilImpl.DEFINITIONS_FACTORY + prefix);
		if (definitionsFactory != null) {
			return definitionsFactory;
		}
		else {
			throw new FactoryNotFoundException(
					"DefinitionsFactory (prefix: "+ prefix +") not found.");
		}
	}
	
	
	/**
	 * Get tiles DefinitionsFactoryConfig object
	 * 
	 * @param prefix Module prefix
	 * @param action Action object
	 * @param request ServletRequest object
	 * @return DefinitionsFactoryConfig object
	 * @throws FactoryNotFoundException
	 */
	public static DefinitionsFactoryConfig getTilesDefinitionsFactoryConfig(
			String prefix,
			Action action,
			ServletRequest request)
		throws FactoryNotFoundException {
		
		DefinitionsFactory definitionsFactory
			= StrutsUtils.getTilesDefinitionsFactory(prefix, action, request);
		
		return definitionsFactory.getConfig();
	}
	
	
	/**
	 * Get tiles ComponentDefinition object
	 * 
	 * @param prefix Module prefix
	 * @param path Path string
	 * @param action Action object
	 * @param request ServletRequest object
	 * @return ComponentDefinition object
	 * @throws NoSuchDefinitionException
	 * @throws DefinitionsFactoryException
	 */
	public static ComponentDefinition getTilesComponentDefinition(
			String prefix,
			String path,
			Action action,
			ServletRequest request)
		throws NoSuchDefinitionException, DefinitionsFactoryException {

		DefinitionsFactory definitionsFactory
			= StrutsUtils.getTilesDefinitionsFactory(prefix, action, request);
		ServletContext context = action.getServlet().getServletContext();
		ComponentDefinition componentDefinition
			= definitionsFactory.getDefinition(path, request, context);
			
		return componentDefinition;
	}
	
}
