/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2007 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.webconsole.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sourceforge.webframe.ibatis.IBatisUtils;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.web.struts.ActionSupport;

import com.ibatis.sqlmap.engine.impl.SqlMapClientImpl;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;

/**
 * IBatisMappedStatementDetailsAction
 *
 * @author Yomei Komiya
 * @since 0.9.2
 *
 * @version $Id: IBatisMappedStatementDetailsAction.java 6 2007-06-27 13:49:06Z whitestar $
 */
public class IBatisMappedStatementDetailsAction extends ActionSupport {

	public ActionForward execute(
			ActionMapping mapping,
			ActionForm actionForm,
			HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		
		MappedStatement mappedStatement = null;
		try {
			String id = request.getParameter("id");
			if (id != null && !id.equals("")) {
				SqlMapClientImpl sqlMapClientImpl
					= (SqlMapClientImpl)this.getWebApplicationContext()
						.getBean("sqlMapClient");
				
				mappedStatement = IBatisUtils.getMappedStatement(id, sqlMapClientImpl);
			}
			else {
				throw new IllegalArgumentException("id is required.");
			}
		}
		catch (Exception e) {
			e.printStackTrace();
			request.setAttribute("errorMessage", e.getMessage());
			
			return mapping.findForward("failure");
		}
		finally {
			request.setAttribute("mappedStatement", mappedStatement);
		}
		
		return mapping.findForward("iBatisMappedStatementDetails");
	}

}
