/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2007 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.webconsole.action;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sourceforge.webframe.springframework.util.SpringBeanHolder;
import jp.sourceforge.webframe.springframework.util.SpringContextHolder;
import jp.sourceforge.webframe.springframework.util.SpringUtils;

import org.apache.commons.beanutils.BeanMap;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

/**
 * SpringBeanDetailsAction
 *
 * @author Yomei Komiya
 * @since 0.9.2
 *
 * $Id: SpringBeanDetailsAction.java 6 2007-06-27 13:49:06Z whitestar $
 */
public class SpringBeanDetailsAction extends Action {

	public ActionForward execute(
			ActionMapping mapping,
			ActionForm actionForm,
			HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		
		String beanName = null;
		SpringBeanHolder beanHolder = null;
		Map actualSingletonBeanMap = null;
		try {
			SpringContextHolder contextHolder
				= SpringUtils.getSpringContextHolder(this);
			
			beanName = request.getParameter("beanName");
			if (beanName == null) {
				String objectId = request.getParameter("objectId");
				if (objectId != null) {
					beanName
						= contextHolder.getBeanNameBySingletonObjectId(objectId);
				}
				else {
					throw new IllegalArgumentException(
							"Either beanName or objectId is required.");
				}
			}
			
			beanHolder = contextHolder.getBeanHolder(beanName);
			
			Object actualSingleton = beanHolder.getActualSingleton();
			if (actualSingleton != null) {
				actualSingletonBeanMap = new BeanMap(actualSingleton);
			}
			else {
				actualSingletonBeanMap = null;
			}
		}
		catch (NoSuchBeanDefinitionException nsbde) {
			nsbde.printStackTrace();
			request.setAttribute("errorMessage",
					"No bean named '" + beanName
					+ "' is defined in Spring DI Container.");
			
			return mapping.findForward("failure");
		}
		catch (Exception e) {
			e.printStackTrace();
			request.setAttribute("errorMessage", e.getMessage());
			
			return mapping.findForward("failure");
		}
		finally {
			request.setAttribute("beanHolder", beanHolder);
			request.setAttribute("actualSingletonBeanMap", actualSingletonBeanMap);
		}
		
		return mapping.findForward("springBeanDetails");
	}

}
