/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.compass.entity;

import java.net.URLEncoder;

/**
 * TracWikiBean
 *
 * @author Yomei Komiya
 * @since 0.9.0
 *
 * @deprecated Use jp.sourceforge.metasearch.compass.entity.TracWikiBean
 *		of <a href="http://metasearch.sourceforge.jp/">MetaSearch project</a>
 * @version $Id: TracWikiBean.java 6 2007-06-27 13:49:06Z whitestar $
 */
abstract public class TracWikiBean extends SearchableGenericEntity {
	
	public void buildIdentifier() {
		// http://hostname/context/wiki/<URL encoded page name>
		try {
			this.setIdentifier(
				this.getResourceContext()
				+ URLEncoder.encode(this.getLocalIdentifier(), "UTF-8"));
		}
		catch (Exception e) {
			this.setIdentifier(null);
			e.printStackTrace();
		}
	}

}
