/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.example.metasearch.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sourceforge.webframe.example.metasearch.form.SearchActionForm;
import jp.sourceforge.webframe.compass.SearchFailedException;
import jp.sourceforge.webframe.compass.SearchResult;
import jp.sourceforge.webframe.compass.IndexSearcher;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.web.struts.ActionSupport;

/**
 * RefineSearchAction
 *
 * @author Yomei Komiya
 *
 * $Id: RefineSearchAction.java 6 2007-06-27 13:49:06Z whitestar $
 */
public class RefineSearchAction extends ActionSupport {

	public ActionForward execute(
			ActionMapping mapping,
			ActionForm actionForm,
			HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		
		SearchActionForm form = (SearchActionForm)actionForm;
		String query = form.getQuery();
		String currentQuery = form.getCurrentQuery();
		int num = form.getNum();
		int start = form.getStart();

		SearchResult result = null;
		try {
			IndexSearcher searcher
				= (IndexSearcher)this.getWebApplicationContext()
					.getBean("indexSearcher");

			// Secure Search
			String[] userRoles = {"everyone"};
			result = searcher.find(query, currentQuery, num, start, userRoles);
		}
		catch (SearchFailedException sfe) {
			sfe.printStackTrace();
			request.setAttribute("errorMessage", sfe.getMessage());
			
			result = new SearchResult();
			result.setQuery(query);
			result.setCurrentQuery(currentQuery);
			result.setNum(num);
			result.setStart(start);
			
			return mapping.findForward("searchResult");
		}
		finally {
			request.setAttribute("result", result);
		}
		
		return mapping.findForward("searchResult");
	}

}
