/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.test;

import junit.framework.TestCase;

import org.easymock.EasyMock;
import org.easymock.IMocksControl;

/**
 * AbstractEasyMockTestCase
 *
 * @author Yomei Komiya
 * @since 0.9.2
 *
 * @version $Id: AbstractEasyMockTestCase.java 6 2007-06-27 13:49:06Z whitestar $
 */
abstract public class AbstractEasyMockTestCase extends TestCase {

	/**
	 * Easy Mock's mocks controller
	 */
	protected IMocksControl mocksControl = EasyMock.createControl();
	
	
	protected void setUp() throws Exception {
		super.setUp();
		
		// change other mocks control
		//this.mocksControl = EasyMock.createNiceControl();
		//this.mocksControl = EasyMock.createStrictControl();
	}

	
	protected void tearDown() throws Exception {
		super.tearDown();
	}

}
