/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2007 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.velocity.tools.generic;

import junit.framework.TestCase;

public class StringToolTest extends TestCase {

	private StringTool stringTool = null;
	
	
	protected void setUp() throws Exception {
		super.setUp();
		
		this.stringTool = new StringTool();
	}

	
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	
	/*
	 * 'jp.sourceforge.webframe.velocity.tools.generic.StringTool.capitalize(String)'
	 */
	public void testCapitalize() {
		assertEquals("", stringTool.capitalize(null));
		assertEquals("Capitalize", stringTool.capitalize("capitalize"));
	}

	
	/*
	 * 'jp.sourceforge.webframe.velocity.tools.generic.StringTool.capitalizeAllWords(String)'
	 */
	public void testCapitalizeAllWords() {
		assertEquals("", stringTool.capitalizeAllWords(null));
		assertEquals("Capitalize All Words",
				stringTool.capitalizeAllWords("capitalize all words"));
	}

	
	/*
	 * 'jp.sourceforge.webframe.velocity.tools.generic.StringTool.defaultIfEmpty(String, String)'
	 */
	public void testDefaultIfEmpty() {
		assertEquals("original", stringTool.defaultIfEmpty("original", "defaultStr"));
		assertEquals("defaultStr", stringTool.defaultIfEmpty(null, "defaultStr"));
		assertEquals("defaultStr", stringTool.defaultIfEmpty("", "defaultStr"));
	}

	
	/*
	 * 'jp.sourceforge.webframe.velocity.tools.generic.StringTool.defaultString(String)'
	 */
	public void testDefaultStringString() {
		assertEquals("original", stringTool.defaultString("original"));
		assertEquals("", stringTool.defaultString(null));
		assertEquals("", stringTool.defaultString(""));
	}

	
	/*
	 * 'jp.sourceforge.webframe.velocity.tools.generic.StringTool.defaultString(String, String)'
	 */
	public void testDefaultStringStringString() {
		assertEquals("original", stringTool.defaultString("original", "defaultStr"));
		assertEquals("defaultStr", stringTool.defaultString(null, "defaultStr"));
		assertEquals("", stringTool.defaultString("", "defaultStr"));
	}

	
	/*
	 * 'jp.sourceforge.webframe.velocity.tools.generic.StringTool.nvl(String, String)'
	 */
	public void testNvl() {
		assertEquals("original", stringTool.nvl("original", "defaultStr"));
		assertEquals("defaultStr", stringTool.nvl(null, "defaultStr"));
		assertEquals("", stringTool.nvl("", "defaultStr"));
	}

	
	/*
	 * 'jp.sourceforge.webframe.velocity.tools.generic.StringTool.toLowerCase(String)'
	 */
	public void testToLowerCase() {
		assertEquals("", stringTool.toLowerCase(null));
		assertEquals("tolowercase", stringTool.toLowerCase("toLowerCase"));
	}

	
	/*
	 * 'jp.sourceforge.webframe.velocity.tools.generic.StringTool.toUpperCase(String)'
	 */
	public void testToUpperCase() {
		assertEquals("", stringTool.toUpperCase(null));
		assertEquals("TOUPPERCASE", stringTool.toUpperCase("toUpperCase"));
	}

	
	/*
	 * 'jp.sourceforge.webframe.velocity.tools.generic.StringTool.nlToBrTag(String)'
	 */
	public void testNlToBrTag() {
		assertEquals("", stringTool.nlToBrTag(null));
		assertEquals("new line<br/> to<br/> br tag",
				stringTool.nlToBrTag("new line\n to\n br tag"));
	}

	
	/*
	 * 'jp.sourceforge.webframe.velocity.tools.generic.StringTool.replace(String, String, String)'
	 */
	public void testReplace() {
		assertEquals("", stringTool.replace(null, "target", "replacement"));
		assertEquals("replacement string",
				stringTool.replace("target string", "target", "replacement"));
	}

	
	/*
	 * 'jp.sourceforge.webframe.velocity.tools.generic.StringTool.trim(String)'
	 */
	public void testTrim() {
		assertEquals("", stringTool.trim(null));
		assertEquals("trim string", stringTool.trim("\t  trim string   "));
	}

	
	/*
	 * 'jp.sourceforge.webframe.velocity.tools.generic.StringTool.strip(String)'
	 */
	public void testStripString() {
		assertEquals("", stringTool.strip(null));
		assertEquals("abc", stringTool.strip("   abc  "));
	}

	
	/*
	 * 'jp.sourceforge.webframe.velocity.tools.generic.StringTool.strip(String, String)'
	 */
	public void testStripStringString() {
		assertEquals("", stringTool.strip(null, "xyz"));
		assertEquals("axbzc", stringTool.strip("xyaxbzcz", "xyz"));
	}

	
	/*
	 * 'jp.sourceforge.webframe.velocity.tools.generic.StringTool.truncate(String, int)'
	 */
	public void testTruncateStringInt() {
		assertEquals("", stringTool.truncate(null, 5));
		assertEquals("trunc", stringTool.truncate("truncate string", 5));
		assertEquals("a bit", stringTool.truncate("a bit", 5));
	}

	
	/*
	 * 'jp.sourceforge.webframe.velocity.tools.generic.StringTool.truncate(String, int, String)'
	 */
	public void testTruncateStringIntString() {
		assertEquals("", stringTool.truncate(null, 5, "---"));
		assertEquals("trunc...", stringTool.truncate("truncate string", 5, null));
		assertEquals("trunc---", stringTool.truncate("truncate string", 5, "---"));
		assertEquals("a bit", stringTool.truncate("a bit", 5, "---"));
	}

	
	public void testFirstToken() {
		assertEquals("", stringTool.firstToken(null, ","));
		assertEquals("all", stringTool.firstToken("all,token", ","));
	}
	
	
	public void testLastToken() {
		assertEquals("", stringTool.lastToken(null, "."));
		assertEquals("token", stringTool.lastToken("all.token", "."));
	}
	
	
	/*
	 * 'jp.sourceforge.webframe.velocity.tools.generic.StringTool.left(String, int)'
	 */
	public void testLeft() {
		assertEquals("", stringTool.left(null, 5));
		assertEquals("left*", stringTool.left("left*string", 5));
	}

	
	/*
	 * 'jp.sourceforge.webframe.velocity.tools.generic.StringTool.leftPad(String, int)'
	 */
	public void testLeftPadStringInt() {
		assertEquals("          ", stringTool.leftPad(null, 10));
		assertEquals("  left pad", stringTool.leftPad("left pad", 10));
	}

	
	/*
	 * 'jp.sourceforge.webframe.velocity.tools.generic.StringTool.leftPad(String, int, String)'
	 */
	public void testLeftPadStringIntString() {
		assertEquals("**********", stringTool.leftPad(null, 10, "*"));
		assertEquals("##left pad", stringTool.leftPad("left pad", 10, "#"));
	}

	
	/*
	 * 'jp.sourceforge.webframe.velocity.tools.generic.StringTool.right(String, int)'
	 */
	public void testRight() {
		assertEquals("", stringTool.right(null, 5));
		assertEquals("tring", stringTool.right("right*string", 5));
	}

	
	/*
	 * 'jp.sourceforge.webframe.velocity.tools.generic.StringTool.rightPad(String, int)'
	 */
	public void testRightPadStringInt() {
		assertEquals("          ", stringTool.rightPad(null, 10));
		assertEquals("right pad ", stringTool.rightPad("right pad", 10));
	}

	
	/*
	 * 'jp.sourceforge.webframe.velocity.tools.generic.StringTool.rightPad(String, int, String)'
	 */
	public void testRightPadStringIntString() {
		assertEquals("**********", stringTool.rightPad(null, 10, "*"));
		assertEquals("right pad#", stringTool.rightPad("right pad", 10, "#"));
	}

	
	/*
	 * 'jp.sourceforge.webframe.velocity.tools.generic.StringTool.join(Object[])'
	 */
	public void testJoinObjectArray() {
		assertEquals("", stringTool.join(null));
		String[] array = new String[]{"a", "b", "c"};
		assertEquals("abc", stringTool.join(array));
	}

	
	/*
	 * 'jp.sourceforge.webframe.velocity.tools.generic.StringTool.join(Object[], String)'
	 */
	public void testJoinObjectArrayString() {
		assertEquals("", stringTool.join(null));
		String[] array = new String[]{"a", "b", "c"};
		assertEquals("a#b#c", stringTool.join(array, "#"));
	}

	
	/*
	 * 'jp.sourceforge.webframe.velocity.tools.generic.StringTool.wordwrap(String, int)'
	 */
	public void testWordwrapStringInt() {
		assertEquals("", stringTool.wordwrap(null, 60));
		String str =
			"Licensed under the Apache License, Version 2.0 (the \"License\"); "
			+ "you may not use this file except in compliance with the License. "
			+ "You may obtain a copy of the License at "
			+ "\thttp://www.apache.org/licenses/LICENSE-2.0 "
			+ "Unless required by applicable law or agreed to in writing, software "
			+ "distributed under the License is distributed on an \"AS IS\" BASIS, "
			+ "WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. "
			+ "See the License for the specific language governing permissions and "
			+ "limitations under the License.";
		System.out.println(stringTool.wordwrap(str, 60));
	}

	
	/*
	 * 'jp.sourceforge.webframe.velocity.tools.generic.StringTool.wordwrap(String, int, String)'
	 */
	public void testWordwrapStringIntString() {
		assertEquals("", stringTool.wordwrap(null, 60, ""));
		String str =
			"Licensed under the Apache License, Version 2.0 (the \"License\"); "
			+ "you may not use this file except in compliance with the License. "
			+ "You may obtain a copy of the License at "
			+ "	http://www.apache.org/licenses/LICENSE-2.0 "
			+ "Unless required by applicable law or agreed to in writing, software "
			+ "distributed under the License is distributed on an \"AS IS\" BASIS, "
			+ "WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. "
			+ "See the License for the specific language governing permissions and "
			+ "limitations under the License.";
		System.out.println(stringTool.wordwrap(str, 60, "\n\t"));
	}

}
