/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.webframe.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import jp.sourceforge.webframe.io.FileLine;
import jp.sourceforge.webframe.io.FileScanner;
import jp.sourceforge.webframe.io.LineConsumer;
import jp.sourceforge.webframe.io.ScanAbortException;
import org.apache.commons.io.IOUtils;

public class DefaultByLineFileScanner
implements FileScanner {
    private LineConsumer lineConsumer = null;

    public DefaultByLineFileScanner() {
    }

    public DefaultByLineFileScanner(LineConsumer lineConsumer) {
        this.lineConsumer = lineConsumer;
    }

    public void scan(String filePath, String fileEncodingCharset) throws ScanAbortException {
        File file = new File(filePath);
        this.scan(file, fileEncodingCharset);
    }

    public void scan(File file, String fileEncodingCharset) throws ScanAbortException {
        BufferedReader br = null;
        try {
            try {
                String lineString;
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), fileEncodingCharset));
                FileLine fileLine = new FileLine();
                fileLine.setFilePath(file.getAbsolutePath());
                int lineNumber = 0;
                while ((lineString = br.readLine()) != null) {
                    fileLine.setLineNumber(++lineNumber);
                    fileLine.setLineString(lineString);
                    this.lineConsumer.consume(fileLine);
                }
            }
            catch (ScanAbortException sae) {
                sae.printStackTrace();
                throw sae;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new ScanAbortException(ioe.getMessage(), ioe.getCause());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(br);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)br);
    }

    public LineConsumer getLineConsumer() {
        return this.lineConsumer;
    }

    public void setLineConsumer(LineConsumer lineConsumer) {
        this.lineConsumer = lineConsumer;
    }
}

