/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.webframe.io;

import java.io.File;
import java.net.URL;
import jp.sourceforge.webframe.io.DefaultByLineFileScanner;
import jp.sourceforge.webframe.io.FileLine;
import jp.sourceforge.webframe.io.LineConsumer;
import jp.sourceforge.webframe.io.ScanAbortException;
import jp.sourceforge.webframe.test.AbstractEasyMockTestCase;
import org.easymock.EasyMock;

public class DefaultByLineFileScannerTest
extends AbstractEasyMockTestCase {
    private static final String SAMPLE_CSV_FILE = "/testdata/CsvSample.EUC-JP.csv";
    private DefaultByLineFileScanner fileScanner = null;
    private LineConsumer lineConsumerMock = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.lineConsumerMock = (LineConsumer)this.mocksControl.createMock(LineConsumer.class);
        this.fileScanner = new DefaultByLineFileScanner(this.lineConsumerMock);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testScanStringString() throws Exception {
        URL fileUrl = ((Object)((Object)this)).getClass().getResource(SAMPLE_CSV_FILE);
        String encoding = "EUC-JP";
        this.mocksControl.reset();
        this.lineConsumerMock.consume((FileLine)EasyMock.isA(FileLine.class));
        EasyMock.expectLastCall().times(5);
        this.mocksControl.replay();
        this.fileScanner.scan(fileUrl.getPath(), encoding);
        this.mocksControl.verify();
    }

    public void testScanFileString() throws Exception {
        URL fileUrl = ((Object)((Object)this)).getClass().getResource(SAMPLE_CSV_FILE);
        File file = new File(fileUrl.getPath());
        String encoding = "EUC-JP";
        this.mocksControl.reset();
        this.lineConsumerMock.consume((FileLine)EasyMock.isA(FileLine.class));
        EasyMock.expectLastCall().times(5);
        this.mocksControl.replay();
        this.fileScanner.scan(file, encoding);
        this.mocksControl.verify();
        this.mocksControl.reset();
        this.lineConsumerMock.consume((FileLine)EasyMock.isA(FileLine.class));
        EasyMock.expectLastCall().times(3);
        this.lineConsumerMock.consume((FileLine)EasyMock.isA(FileLine.class));
        EasyMock.expectLastCall().andThrow((Throwable)new ScanAbortException());
        this.mocksControl.replay();
        try {
            this.fileScanner.scan(file, encoding);
            DefaultByLineFileScannerTest.fail((String)"Scanning must be stopped.");
        }
        catch (ScanAbortException scanAbortException) {
            // empty catch block
        }
        this.mocksControl.verify();
    }
}

