/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.webframe.web.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.LocaleUtils;

public class LocaleFilter
implements Filter {
    private String localeParameter = "lang";
    private String[] acceptableLocaleStrings = new String[0];
    private List acceptableLocales = null;
    private String defaultLocaleString = null;
    private Locale defaultLocale = null;
    private String defaultContentType = "text/html;charset=UTF-8";

    protected void initLocales() {
        this.acceptableLocales = new ArrayList();
        int i = 0;
        while (i < this.acceptableLocaleStrings.length) {
            this.acceptableLocales.add(LocaleUtils.toLocale((String)this.acceptableLocaleStrings[i]));
            ++i;
        }
        this.defaultLocale = LocaleUtils.toLocale((String)this.defaultLocaleString);
    }

    protected Locale resolveAvailableLocale(String userLocaleString) {
        Locale userLocale = null;
        try {
            userLocale = LocaleUtils.toLocale((String)userLocaleString);
            return this.resolveAvailableLocale(userLocale);
        }
        catch (Exception e) {
            return this.defaultLocale;
        }
    }

    protected Locale resolveAvailableLocale(Locale userLocale) {
        if (userLocale != null) {
            String userlanguage = userLocale.getLanguage();
            String userCountry = userLocale.getCountry();
            ArrayList<Locale> languageMatchedLocales = new ArrayList<Locale>();
            for (Locale acceptableLocale : this.acceptableLocales) {
                if (!acceptableLocale.getLanguage().equals(userlanguage)) continue;
                if (acceptableLocale.getCountry().equals(userCountry)) {
                    return acceptableLocale;
                }
                languageMatchedLocales.add(acceptableLocale);
            }
            if (!languageMatchedLocales.isEmpty()) {
                return (Locale)languageMatchedLocales.get(0);
            }
        }
        return this.defaultLocale;
    }

    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.acceptableLocales == null || this.defaultLocale == null) {
            this.initLocales();
        }
        HttpSession session = ((HttpServletRequest)request).getSession();
        Locale headerLocale = null;
        Locale appLocale = null;
        if (request.getParameterMap().containsKey(this.localeParameter)) {
            appLocale = this.resolveAvailableLocale(request.getParameter(this.localeParameter));
            session.setAttribute(this.localeParameter, (Object)appLocale);
        } else {
            appLocale = session.getAttribute(this.localeParameter) != null ? (Locale)session.getAttribute(this.localeParameter) : ((headerLocale = request.getLocale()) != null ? this.resolveAvailableLocale(headerLocale) : this.defaultLocale);
        }
        response.setLocale(appLocale);
        response.setContentType(this.defaultContentType);
        session.setAttribute("org.apache.struts.action.LOCALE", (Object)appLocale);
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    public void setLocaleParameter(String localeParameter) {
        this.localeParameter = localeParameter;
    }

    public final void setLangParameter(String langParameter) {
        this.localeParameter = langParameter;
    }

    public void setAcceptableLocales(String[] acceptableLocaleStrings) {
        this.acceptableLocaleStrings = acceptableLocaleStrings;
    }

    public final void setAcceptableLanguages(String[] acceptableLanguages) {
        this.acceptableLocaleStrings = acceptableLanguages;
    }

    public void setDefaultLocale(String defaultLocaleString) {
        this.defaultLocaleString = defaultLocaleString;
    }

    public final void setDefaultLanguage(String defaultLanguage) {
        this.defaultLocaleString = defaultLanguage;
    }

    public final void setDefaultContentType(String defaultContentType) {
        this.defaultContentType = defaultContentType;
    }
}

