<?php
/*
 * $Id: weblog_recent.php,v 1.1 2003/07/03 13:22:53 wellwine Exp $
 * Copyright (c) 2003 by Jeremy N. Cowgar <jc@cowgar.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * You may not change or alter any portion of this comment or credits
 * of supporting developers from this source code or any supporting
 * source code which is considered copyrighted (c) material of the
 * original comment or credit authors.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

/*
 * $options[0] = max results
 * $options[1] = use avatars
 */
function b_weblog_top_weblogs_show($options) {
  global $xoopsDB,$xoopsUser;

  $options[1] = 1;

  $currentuid = !empty($xoopsUser) ? $xoopsUser->getVar('uid','E') : 0;
  $maxsize=$options[1];
  
  $myts =& MyTextSanitizer::getInstance();
  $block = array();
  $sql = 'SELECT b.user_id,u.uname,u.user_avatar,count(b.blog_id) as count FROM '.$xoopsDB->prefix('weblog').
    ' as b, '.$xoopsDB->prefix('users').' as u '.
    "WHERE (b.private = 'N' OR b.user_id='".$currentuid."')  AND b.user_id=u.uid GROUP BY b.user_id ORDER BY count DESC";

  $rank = 0;
  $result = $xoopsDB->query($sql, $options[0], 0);
  while ($myrow=$xoopsDB->fetchArray($result)) {
    $rank++;
    
    // Get the user, and retrieve his avatar
    $entry = array();
    $entry['rank'] = $rank;
    $entry['use_avatar'] = 0;
    $entry['avatar_img'] = '';
    
    if ($options[1] == 1) {
      if (!empty($myrow['user_avatar']) && $myrow['user_avatar'] != 'blank.gif') {
        $entry['use_avatar'] = 1;
        $entry['avatar_img'] = XOOPS_URL.'/uploads/'.$myrow['user_avatar'];
      }
    }
    $entry['profile_uri'] = XOOPS_URL.'/userinfo.php?uid='.$myrow['user_id'];
    $entry['uname'] = $myrow['uname'];
    $entry['count'] = $myrow['count'];
    $block['entries'][] = $entry;
  }
  
  return $block;
}

/*
 * $options[0] = max results
 * $options[1] = use avatars
 */
function b_weblog_top_weblogs_edit($options) {
  $form  = '<table>';
  $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="'.intval($options[0]).'" /></td></tr>', _MB_RECENT_EDIT_NUMBER_OF_ENTRIES);
  $form .= '</table>';
  return $form;
}

/*
 * $options[0] = number of entries to show
 * $options[1] = max size of the title
 * $options[2] = date format
 * $options[3] = use avatars (only in large mode)
 * $options[4] = size (1=small,2=medium,3=large)
 */
function b_weblog_recent_show($options) {
  global $xoopsDB,$xoopsUser,$xoopsConfig;

  $currentuid = !empty($xoopsUser) ? $xoopsUser->getVar('uid','E') : 0;
  $maxsize=$options[1];
  
  $myts =& MyTextSanitizer::getInstance();
  $block = array();
  $sql = 'SELECT b.blog_id,b.created,b.user_id,b.title,u.uname,u.user_avatar '.
    ' FROM '.$xoopsDB->prefix('weblog').
    ' as b, '.$xoopsDB->prefix('users').' as u '.
    "WHERE (b.private = 'N' OR b.user_id='".$currentuid."') AND b.user_id=u.uid ORDER BY b.created DESC";

  // Need to figure out how to access the module config while in a block
  //$result = $xoopsDB->query($sql, $xoopsModuleConfig['numinrecentblock'], 0);
  $result = $xoopsDB->query($sql, $options[0], 0);
  while ($myrow=$xoopsDB->fetchArray($result)) {
    $entry = array();
    $title = $myts->makeTboxData4Show($myrow["title"]);
    if ( !XOOPS_USE_MULTIBYTES && $options[4] != 3) {
      if (strlen($myrow['title']) >= $maxsize) {
        $title = $myts->makeTboxData4Show(substr($myrow['title'],0,($maxsize -1)))."...";
      }
    }
    
    $entry['use_avatar'] = 0;
    $entry['avatar_img'] = '';
    
    if ($options[3] == 1) {
      if (!empty($myrow['user_avatar']) && $myrow['user_avatar'] != 'blank.gif') {
        $entry['use_avatar'] = 1;
        $entry['avatar_img'] = XOOPS_URL.'/uploads/'.$myrow['user_avatar'];
      }
    }
    $entry['uname'] = $myrow['uname'];
    $entry['profile_uri'] = XOOPS_URL.'/userinfo.php?uid='.$myrow['user_id'];
    $entry['title'] = $title;
    $entry['blog_id'] = $myrow['blog_id'];
    $entry['date'] = formatTimestamp($myrow['created'],$options[2],$xoopsConfig['default_TZ']);
    $block['entries'][] = $entry;
  }

  $block['type'] = $options[4];

  return $block;
}

function b_weblog_recent_edit($options) {
  $form  = '<table>';
  $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="'.intval($options[0]).'" /></td></tr>', _MB_RECENT_EDIT_NUMBER_OF_ENTRIES);
  $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="'.intval($options[1]).'" /></td></tr>', _MB_RECENT_EDIT_MAX_TITLE_LENGTH);
  $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="'.$options[2].'" /></td></tr>', _MB_RECENT_EDIT_DATE_FORMAT);
  $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="'.$options[3].'" /></td></tr>', _MB_RECENT_EDIT_USE_AVATARS);
  $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="'.$options[4].'" /></td></tr>', _MB_RECENT_EDIT_TYPE);
  $form .= '</table>';
  return $form;
}
?>