<?php
/**
 * $Id: xoops_version.php,v 1.4 2003/07/07 13:56:35 wellwine Exp $
 * Copyright (c) 2003 by Jeremy N. Cowgar <jc@cowgar.com>
 * Copyright (c) 2003 by Hiro SAKAI (http://wellwine.zive.net/)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * You may not change or alter any portion of this comment or credits
 * of supporting developers from this source code or any supporting
 * source code which is considered copyrighted (c) material of the
 * original comment or credit authors.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

$modversion['name'] = _MI_WEBLOG_NAME;
$modversion['version'] = 1.10;
$modversion['description'] = _MI_WEBLOG_DESC;
$modversion['author'] = "Jeremy Cowgar<br />(http://cowgar.com/)<br />wellwine<br />(http://wellwine.zive.net)";
$modversion['credits'] = "Xoops System";
$modversion['help'] = "weblog_help.html";
$modversion['license'] = "GPL";
$modversion['official'] = 0;
$modversion['image'] = "images/weblog_slogo.png";
$modversion['dirname'] = "weblog";

// Sql file (must contain sql generated by phpMyAdmin or phpPgAdmin)
// All tables should not have any prefix!
$modversion['sqlfile']['mysql'] = "sql/mysql.sql";

// Tables created by sql file (without prefix!)
$modversion['tables'][0] = 'weblog';

// Admin things
$modversion['hasAdmin'] = 1;
//$modversion['adminindex'] = "admin/index.php";
//$modversion['adminmenu'] = "admin/menu.php";

// Config Options
$modversion['config'][1]['name'] = 'numperpage';
$modversion['config'][1]['title'] = '_MI_WEBLOG_NUMPERPAGE';
$modversion['config'][1]['description'] = '_MI_WEBLOG_NUMPERPAGEDSC';
$modversion['config'][1]['formtype'] = 'select';
$modversion['config'][1]['valuetype'] = 'int';
$modversion['config'][1]['default'] = 10;
$modversion['config'][1]['options'] = array('5' => 5, '10' => 10, '15' => 15, '20' => 20, '25' => 25, '30' => 30, '50' => 50);

$modversion['config'][2]['name'] = 'dateformat';
$modversion['config'][2]['title'] = '_MI_WEBLOG_DATEFORMAT';
$modversion['config'][2]['description'] = '_MI_WEBLOG_DATEFORMATDSC';
$modversion['config'][2]['formtype'] = 'textbox';
$modversion['config'][2]['valuetype'] = 'text';
$modversion['config'][2]['default'] = 'Y/m/d';

$modversion['config'][3]['name'] = 'timeformat';
$modversion['config'][3]['title'] = '_MI_WEBLOG_TIMEFORMAT';
$modversion['config'][3]['description'] = '_MI_WEBLOG_TIMEFORMATDSC';
$modversion['config'][3]['formtype'] = 'textbox';
$modversion['config'][3]['valuetype'] = 'text';
$modversion['config'][3]['default'] = 'g:i a';

$modversion['config'][4]['name'] = 'update_reads_when';
$modversion['config'][4]['title'] = '_MI_WEBLOG_UPDATE_READS_WHEN';
$modversion['config'][4]['description'] = '_MI_WEBLOG_UPDATE_READS_WHENDSC';
$modversion['config'][4]['formtype'] = 'select';
$modversion['config'][4]['valuetype'] = 'int';
$modversion['config'][4]['default'] = 1;
$modversion['config'][4]['options'] = array('_MI_WEBLOG_UPDATE_READS_WHEN1'=>1,
                                            '_MI_WEBLOG_UPDATE_READS_WHEN2'=>2,
                                            '_MI_WEBLOG_UPDATE_READS_WHEN3'=>3);

$modversion['config'][5]['name'] = 'showavatar';
$modversion['config'][5]['title'] = '_MI_WEBLOG_SHOWAVATAR';
$modversion['config'][5]['description'] = '_MI_WEBLOG_SHOWAVATARDSC';
$modversion['config'][5]['formtype'] = 'yesno';
$modversion['config'][5]['valuetype'] = 'int';
$modversion['config'][5]['default'] = 1;

$modversion['config'][6]['name'] = 'alignavatar';
$modversion['config'][6]['title'] = '_MI_WEBLOG_ALIGNAVATAR';
$modversion['config'][6]['description'] = '_MI_WEBLOG_ALIGNAVATARDSC';
$modversion['config'][6]['formtype'] = 'select';
$modversion['config'][6]['valuetype'] = 'text';
$modversion['config'][6]['options'] = array('right'=>'right',
                                            'left'=>'left',
                                            'top'=>'top',
                                            'middle'=>'middle',
                                            'bottom'=>'bottom');
$modversion['config'][6]['default'] = 'bottom';

$modversion['config'][7]['name'] = 'minentrysize';
$modversion['config'][7]['title'] = '_MI_WEBLOG_MINENTRYSIZE';
$modversion['config'][7]['description'] = '_MI_WEBLOG_MINENTRYSIZEDSC';
$modversion['config'][7]['formtype'] = 'textbox';
$modversion['config'][7]['valuetype'] = 'int';
$modversion['config'][7]['default'] = 75;

$modversion['config'][8]['name'] = 'editorheight';
$modversion['config'][8]['title'] = '_MI_WEBLOG_EDITORHEIGHT';
$modversion['config'][8]['description'] = '_MI_WEBLOG_EDITORHEIGHTDSC';
$modversion['config'][8]['formtype'] = 'textbox';
$modversion['config'][8]['valuetype'] = 'int';
$modversion['config'][8]['default'] = 20;

$modversion['config'][9]['name'] = 'editorwidth';
$modversion['config'][9]['title'] = '_MI_WEBLOG_EDITORWIDTH';
$modversion['config'][9]['description'] = '_MI_WEBLOG_EDITORWIDTHDSC';
$modversion['config'][9]['formtype'] = 'textbox';
$modversion['config'][9]['valuetype'] = 'int';
$modversion['config'][9]['default'] = 70;

$modversion['config'][10]['name'] = 'adminonly';
$modversion['config'][10]['title'] = '_MI_WEBLOG_ONLYADMIN';
$modversion['config'][10]['description'] = '_MI_WEBLOG_ONLYADMINDSC';
$modversion['config'][10]['formtype'] = 'yesno';
$modversion['config'][10]['valuetype'] = 'int';
$modversion['config'][10]['default'] = 0;

// wellwine for read cookie begins
$modversion['config'][11]['name'] = 'expiration';
$modversion['config'][11]['title'] = '_MI_WEBLOG_EXPIRATION';
$modversion['config'][11]['description'] = '_MI_WEBLOG_EXPIRATIONDSC';
$modversion['config'][11]['formtype'] = 'textbox';
$modversion['config'][11]['valuetype'] = 'int';
$modversion['config'][11]['default'] = 86400;

// wellwine for rss feed
$modversion['config'][12]['name'] = 'rssshow';
$modversion['config'][12]['title'] = '_MI_WEBLOG_RSSSHOW';
$modversion['config'][12]['description'] = '_MI_WEBLOG_RSSSHOWDSC';
$modversion['config'][12]['formtype'] = 'yesno';
$modversion['config'][12]['valuetype'] = 'int';
$modversion['config'][12]['default'] = 1;

$modversion['config'][13]['name'] = 'rssmax';
$modversion['config'][13]['title'] = '_MI_WEBLOG_RSSMAX';
$modversion['config'][13]['description'] = '_MI_WEBLOG_RSSMAXDSC';
$modversion['config'][13]['formtype'] = 'textbox';
$modversion['config'][13]['valuetype'] = 'int';
$modversion['config'][13]['default'] = 10;

// Templates
$modversion['templates'][1]['file'] = 'weblog_entries.html';
$modversion['templates'][1]['description'] = _MI_WEBLOG_TEMPLATE_ENTRIESDSC;
$modversion['templates'][2]['file'] = 'weblog_post.html';
$modversion['templates'][2]['description'] = _MI_WEBLOG_TEMPLATE_POSTDSC;
$modversion['templates'][3]['file'] = 'weblog_details.html';
$modversion['templates'][3]['description'] = _MI_WEBLOG_TEMPLATE_DETAILSDSC;
$modversion['templates'][4]['file'] = 'weblog_rss.html';
$modversion['templates'][4]['description'] = _MI_WEBLOG_TEMPLATE_RSSFEEDDSC;
$modversion['templates'][5]['file'] = 'weblog_print.html';
$modversion['templates'][5]['description'] = _MI_WEBLOG_TEMPLATE_PRINTDSC;
$modversion['templates'][6]['file'] = 'weblog_archive.html';
$modversion['templates'][6]['description'] = _MI_WEBLOG_TEMPLATE_ARCHIVEDSC;

// Search
$modversion['hasSearch'] = 1;
$modversion['search']['file'] = 'include/search.inc.php';
$modversion['search']['func'] = 'weblog_search';

//Blocks
$modversion['blocks'][1]['file'] = 'weblog_recent.php';
$modversion['blocks'][1]['name'] = _MI_WEBLOG_RECENT_BNAME1;
$modversion['blocks'][1]['description'] = _MI_WEBLOG_RECENT_BNAME1_DESC;
$modversion['blocks'][1]['show_func'] = 'b_weblog_recent_show';
$modversion['blocks'][1]['edit_func'] = 'b_weblog_recent_edit';
$modversion['blocks'][1]['template'] = 'weblog_block_recent.html';
$modversion['blocks'][1]['options'] = '10|25|Y/m/d|1|1';

$modversion['blocks'][2]['file'] = 'weblog_recent.php';
$modversion['blocks'][2]['name'] = _MI_WEBLOG_TOP_WEBLOGS;
$modversion['blocks'][2]['description'] = _MI_WEBLOG_TOP_WEBLOGS_DESC;
$modversion['blocks'][2]['show_func'] = 'b_weblog_top_weblogs_show';
$modversion['blocks'][2]['edit_func'] = 'b_weblog_top_weblogs_edit';
$modversion['blocks'][2]['template'] = 'weblog_block_top_weblogs.html';
$modversion['blocks'][2]['options'] = '10';

// Menu
$modversion['hasMain'] = 1;
$modversion['sub'][1]['name'] = _MI_WEBLOG_SMNAME1;
$modversion['sub'][1]['url'] = 'myblog.php';
$modversion['sub'][2]['name'] = _MI_WEBLOG_SMNAME2;
$modversion['sub'][2]['url'] = 'post.php';
$modversion['sub'][3]['name'] = _MI_WEBLOG_SMNAME3;
$modversion['sub'][3]['url'] = 'archive.php';

// Smarty
$modversion['use_smarty'] = 1;

// Comments
$modversion['hasComments'] = 1;
$modversion['comments']['pageName'] = 'details.php';
$modversion['comments']['itemName'] = 'blog_id';

$modversion['comments']['callbackFile'] = 'include/comment_functions.php';
$modversion['comments']['callback']['approve'] = 'weblog_com_approve';
$modversion['comments']['callback']['update'] = 'weblog_com_update';

// Notifications
$modversion['hasNotification'] = 1;

$modversion['notification']['lookup_file'] = 'include/notification.inc.php';
$modversion['notification']['lookup_func'] = 'blog_info';

$modversion['notification']['category'][1]['name'] = 'blog';
$modversion['notification']['category'][1]['title'] = _MI_WEBLOG_NOTIFY;
$modversion['notification']['category'][1]['description'] = _MI_WEBLOG_NOTIFYDSC;
$modversion['notification']['category'][1]['subscribe_from'] = 'index.php';
$modversion['notification']['category'][1]['item_name'] = 'user_id';
$modversion['notification']['category'][1]['allow_bookmark'] = 1;

$modversion['notification']['category'][2]['name'] = 'blog_entry';
$modversion['notification']['category'][2]['title'] = _MI_WEBLOG_ENTRY_NOTIFY;
$modversion['notification']['category'][2]['description'] = _MI_WEBLOG_ENTRY_NOTIFYDSC;
$modversion['notification']['category'][2]['subscribe_from'] = 'details.php';
$modversion['notification']['category'][2]['item_name'] = 'blog_id';
$modversion['notification']['category'][2]['allow_bookmark'] = 1;

$modversion['notification']['event'][1]['name'] = 'add';
$modversion['notification']['event'][1]['category'] = 'blog';
$modversion['notification']['event'][1]['title'] = _MI_WEBLOG_ADD_NOTIFY;
$modversion['notification']['event'][1]['caption'] = _MI_WEBLOG_ADD_NOTIFYCAP;
$modversion['notification']['event'][1]['description'] = _MI_WEBLOG_ADD_NOTIFYDSC;
$modversion['notification']['event'][1]['mail_template'] = 'weblog_add_notify';
$modversion['notification']['event'][1]['mail_subject'] = _MI_WEBLOG_ADD_NOTIFYSBJ;
?>
