/*
 * $Id: WebProjectAdapterFactoryTest.java,v 1.3 2004/04/01 05:48:15 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.tests;

import junit.framework.TestCase;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.NullProgressMonitor;

import com.narucy.webpub.core.WebProject;

/**
 * 
 */
public class WebProjectAdapterFactoryTest extends TestCase {

	public WebProjectAdapterFactoryTest(String arg0) {
		super(arg0);
	}
	
	public void testGetAdapter() throws Exception {
		IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject("aproject");
		try{
			WebProject.distributeNewProject(
				proj, "a", "b", "c", new NullProgressMonitor() );
			proj.refreshLocal(IResource.DEPTH_INFINITE, new NullProgressMonitor());
		
			WebProject wp = (WebProject)proj.getNature(WebProject.ID_NATURE);
			assertEquals("a", wp.getString(WebProject.KEY_HTSOURCES_FOLDER));
			assertEquals("b", wp.getString(WebProject.KEY_SCRIPTS_FOLDER));
			assertEquals("c", wp.getString(WebProject.KEY_PUBLISH_FOLDER));
		}finally{
			WebpubTestPlugin.forceDelete(proj);
		}
		
	}

}
