/*
 * $Id: TocTest.java,v 1.3 2004/04/01 05:48:16 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.tests.toc;

import java.util.Arrays;

import junit.framework.TestCase;

import com.narucy.webpub.core.toc.*;

/**
 * 
 */
public class TocTest extends TestCase {

	public TocTest(String name) {
		super(name);
	}

	public void test() {
		Toc toc = new Toc("x", null);
		Toc t = (Toc)toc.clone();
		
		t.createTopic("a/a", null);
		t.createTopic("a/b", null);
		
		toc.applyToc(t);
		
		assertEquals(2, toc.getSubtopics().length);
		assertTrue(toc.equals(t));
	}

	public void testClone() {
		Toc toc = new Toc("x", null);
		Toc t = (Toc)toc.clone();
		
		assertFalse(t == toc);
		assertTrue(toc.equals(t));
		
		assertEquals(toc.getHref(), t.getHref());
		assertEquals(toc.getLabel(), t.getLabel());

		String[] keys = toc.getAttributeKeys();
		assertTrue( Arrays.equals(keys, t.getAttributeKeys()) );
		
		for (int i = 0; i < keys.length; i++) {
			String k = keys[i];
			assertEquals(toc.getAttribute(k), t.getAttribute(k));
		}
		
		Topic a = toc.createTopic("a/a", "a-a");
		toc.createTopic("a/b", "a-b");
		toc.createTopic("a/c", "a-c");
		
		assertFalse(toc.equals(t));
		
		t = (Toc)toc.clone();
		assertTrue( toc.equals(t) );
		
		a.createTopic("a/a/a", "a-a-a");
		a.createTopic("a/a/b", "a-a-b");
		a.createTopic("a/a/c", "a-a-c");
		
		assertFalse(toc.equals(t));
		t = (Toc)toc.clone();
		
		assertTrue(toc.equals(t));
	}


}
