#
# $Id: amrita_publisher_test.rb,v 1.1 2004/01/17 12:02:25 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'tempfile'
require 'test/unit'
require 'webpub/amrita_publisher'
require 'webpub/publish_manager'

=begin

AmritaPublisher provides mapping members to html documents.

=end
class AmritaPublisherTest < Test::Unit::TestCase
	
	include Webpub
	
	def setup
		@ws_path = Dir::tmpdir + '/workspace'
		FileUtils.cp_r( File.dirname(__FILE__) + '/test_workspace', @ws_path)
		
		workspace = EclipseWorkspace.instance
		workspace.workspace_path = @ws_path
		
		PublisherRegistory.instance.regist_plugin(File.dirname(__FILE__) + '/../../../com.narucy.webpub.core/')
		@webproj_path = @ws_path + '/web_project'
		assert File.directory?(@webproj_path)
	end
	
	def dist_dummy(ht_filename, script, class_name, method)
		str = '<?publish by="amrita"'
		str += %! script="#{script}"!
		str += %! class="#{class_name}"! if class_name
		str += %! method="#{method}"! if method
		str += "?>\n"
		
		htsrc_dir = @webproj_path + '/ht_sources'
		lines = IO.readlines(htsrc_dir + '/home.html')
		lines[0] = str
		
		file = htsrc_dir + '/' + ht_filename
		open(file, 'w') { |fh|
			fh << lines.join
		}
		file
	end
	
	def test_publish
		f_c = dist_dummy('home_class.html', 'home.rb', 'Home', nil)
		f_m = dist_dummy('home_method.html', 'home_method.rb', nil, 'home')
		f_m_c = dist_dummy('home_class_method.html', 'home_class_method.rb', 'Home', 'home')
		f_err = dist_dummy('home_err.html', 'xxx.rb', 'XXX', nil)
		
		mgr = PublishManager.new
		mgr.result_output = []
		mgr.publish(f_c)
		mgr.publish(f_m)
		mgr.publish(f_m_c)
		mgr.publish(f_err)
		
		assert IO.read(@webproj_path + '/public_html/home_class.html').include?('2001/01/01')
		assert IO.read(@webproj_path + '/public_html/home_method.html').include?('2002/02/02')
		assert IO.read(@webproj_path + '/public_html/home_class_method.html').include?('2003/03/03')
		
		assert_equal(3, mgr.result_output.select { |l| /^<<<OK/ === l }.size )
		assert_equal(1, mgr.result_output.select { |l| /^<<<FAILED/ === l }.size)
		
		assert %r!No such file to load.+scripts/xxx\.rb! === IO.read(@webproj_path + '/public_html/home_err.html')
	end
	
	def teardown
		FileUtils.rm_r(@ws_path)
	end
	
end
