#
# $Id: rd_publisher_test.rb,v 1.1 2004/01/17 12:02:27 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'tempfile'
require 'test/unit'
require 'webpub/rd_publisher'
require 'webpub/publish_manager'


=begin

RD Publisher provides specified 


=end
class RDPublisherTest < Test::Unit::TestCase

	include Webpub

	def setup
		@ws_path = Dir::tmpdir + '/workspace'
		FileUtils.cp_r(File.dirname(__FILE__) + '/test_workspace', @ws_path)
		
		EclipseWorkspace.instance.workspace_path = @ws_path
		reg = PublisherRegistory.instance
		
		reg.clear
		reg.regist_plugin(File.dirname(__FILE__) + '/../../../com.narucy.webpub.core/')
		
		@webproj_path = @ws_path + '/web_project'
	end

	def test_publish_by_rd
		manager = PublishManager.new
		manager.result_output = []
		
		manager.publish( Dir.glob(@webproj_path + '/rd/*.rd') )
		assert_equal( 2, Dir.glob(@webproj_path + '/public_html/pub_rd/*.html').size )
		
		assert( manager.result_output.all? { |l| /^<<<OK,.+,rd,/ === l } )
		
		assert_not_nil %r!<p>First RD.</p>! === File.read(@webproj_path +'/public_html/pub_rd/a.html')
		lines = File.read(@webproj_path +'/public_html/pub_rd/b.html')
		assert_not_nil %r!<p>2nd RD.</p>! === lines
	end

	def teardown
		FileUtils.rm_r(@ws_path)
	end

end
