#
# $Id: erb_publisher.rb,v 1.3 2004/04/16 01:45:06 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'cgi'
require 'erb'
require 'webpub/publisher'
require 'webpub/abstorel_filter'

module Webpub

class ERBPublisher < Publisher

	def initialize
		@abs_to_rel_filter = AbsToRelFilter.new
	end

	def publish( desc)
		begin
			do_publish(desc)
		rescue Exception => err
			
			open( desc.publish_to, 'w') { |fh|
				fh <<
					"<body><h4><pre>#{CGI.escapeHTML(err.message)}</pre></h4>" +
					%Q!<pre>#{CGI.escapeHTML(err.backtrace.join("\n"))}</pre>! +
					'</body>'
			}
			
			raise err.class, err.message.gsub("\n", ' - '), err.backtrace
		end
	end

	protected

	def do_publish(desc)
		@description = desc
		lines = ERB.new( IO.read(desc.publish_from) ).result
		ht_distribute(desc, lines)
	end

end

end
