#
# $Id: publisher.rb,v 1.1 2004/01/17 12:02:26 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'singleton'
require 'rexml/document'
require 'webpub/webproject'
require 'webpub/eclipse_workspace'

module Webpub

def to_fail_str(exception)
	backtrace = exception.backtrace.dup
	
	msg = backtrace.empty? ?
		exception.message :
		([backtrace.shift + ": " + exception.message] + backtrace).join("\n\tfrom ")
	
	msg + "\n"
end

module_function :to_fail_str

class Publisher

#	def publish(publish_desc)
#	end

	def ht_distribute(desc, lines)
		desc.ht_filters.each { |filter|
			lines = filter.respond_to?(:call) ?
				filter.call(desc, lines) :
				filter.filter(desc, lines)
		}
		open(desc.publish_to, 'w') { |fh|
			fh << lines
		}
	end

end

class HTFilter

#	def filter(publish_desc, lines)
#	end

end

class PublisherRegistory

	include Singleton

	attr_accessor :error_output

	def initialize
		@plugins = {}
		@publishers = Hash.new { |hash, key|
			hash[key] = {}
		}
		@error_output = $stderr
	end

	def collect_plugins(plugins_location)
		registed_publisher_ids = []
		if File.directory?(plugins_location)
			Dir.glob(plugins_location + '/*/plugin.xml') { |xmlfile|
				registed_publisher_ids << regist_plugin(xmlfile)
			}
		elsif File.file?(plugins_location)
			regist_plugins_from_entry_file(plugins_location)
		else
			raise ArgumentError, "file not found, musb be specify plugins directory or plugins location cache file: #{plugins_location}"
		end
		
		registed_publisher_ids.flatten.compact
	end

	def regist_plugins_from_entry_file(entry_file)
		lines = IO.readlines(entry_file).map { |l| l.strip }.select { |l| !l.empty? }
		until lines.empty?
			regist(lines.shift, lines.shift, lines.shift)
		end
	end
	
	def regist_plugin(plugin_path)
		xmlfile = File.directory?(plugin_path) ? plugin_path + '/plugin.xml' : plugin_path
		
		doc = REXML::Document.new(IO.read(xmlfile))
		id = doc.elements['plugin'].attributes['id']
		
		registed_publisher_ids = []
		doc.each_element('*/extension') { |ext_elem|
			if ext_elem.attributes['point'] == 'com.narucy.webpub.core.publishers'
				
				dir = File.dirname(xmlfile)
				$: << dir unless $:.include?(dir)
				
				ext_elem.each_element('publisher') { |pub_elem|
					id = pub_elem.attributes['id']
					script_file = File.join(dir, pub_elem.attributes['script'])
					class_name = pub_elem.attributes['class']
					
					registed_publisher_ids << regist(id, script_file, class_name)
				}
			end
		}
		registed_publisher_ids.compact
	end
	
	def ids
		@publishers.map { |k, entry|
			entry[:instance] ? k : nil
		}.compact
	end
	
	def regist(id, script_file, class_name)
		begin
			load script_file
			instance = eval(class_name).new
			@publishers[id][:instance] = instance
			@publishers[id][:script_file] = File.expand_path(script_file)
			
			id
		rescue Exception
			err = $!.dup
			@publishers[id][:error] = err
			@error_output << Webpub::to_fail_str(err)
			
			nil
		end
	end

	def unregist(id)
		@publishers.delete(id)
	end

	def clear
		@publishers.clear
	end

	def [](id)
		@publishers[id][:instance]
	end

	def regist_failed_publisher_ids
		@publishers.map { |id, entry| entry[:error] ? id : nil }.compact
	end

	def registed_error(id)
		@publishers[id][:error]
	end

	def store_publisher_entry_file(filepath)
		open(filepath, 'w') { |fh|
			ids().each { |id|
				fh.puts(id)
				fh.puts("\t" + @publishers[id][:script_file])
				fh.puts("\t" + @publishers[id][:instance].class.name)
				fh.puts
			}
		}
	end

end


class PublishDescription

	def initialize(by, web_proj)
		raise ArgumentError, 'need to specify publish code' unless by
		
		@by = by
		@web_project = web_proj
		@publish_from = nil
		@publish_to = nil
		@arguments = {}
		
		@ht_filters = []
		# @io_filters = [] # for image publihing. (low priority feature)
	end
	
	attr_reader :by, :web_project, :arguments, :ht_filters
	attr_accessor :publish_from, :publish_to
	
	def ht_filter?(desc)
		exts = @web_project[:ht_extensions] || 'html htm erb'
		exts.split.each { |ext|
			return true if File.extname(desc.publish_to) == '.' + ext
		}
		false
	end

end

class PublishDescriptionFactory

	def initialize
		@publish_definications = Hash.new { |hash, file|
			root = REXML::Document.new(IO.read(file)).root
			
			hash[file] = root.get_elements('**/mapping').map do |e|
				pattern = e.attributes['pattern']
				attrs = e.elements['publish'].attributes.to_hash
				
				{
					:pattern => pattern,
					:attributes => attrs,
				}
			end
		}
	end

	def create(from)
		from = File.expand_path(from)
		wp = web_project(from)
		raise ArgumentError, "not found project coniguration file from specify resource: #{from}" unless wp
		
		map = choose_prop_from_file(from) if File.file?(from)
		unless map
			map = choose_prop_from_dir(from)
			return unless map
		end
		unless by = map['by']
			$stdout << "can not get publiing code (#{map}): #{from}\n"
			return
		end
		
		desc = PublishDescription.new(by, wp)
		desc.publish_from = from
		
		if to = map['publish_to']
			if %r!(.+/)\*(\..+?)$! === to
				to = $1 + File.basename(from).gsub(/\..+?$/, $2)
			elsif %r!/$! === to
				to += File.basename(from)
			end
			to = File.join( wp[:publish_dir], to)
		elsif /^#{wp[:htsources_dir]}/i === from
			to = from.sub( wp[:htsources_dir], wp[:publish_dir])
		else
			$stdout << "can't define publish location (invalid publish location?):#{from}:#{wp[:htsources_dir]}\n"
			return
		end
		
		# initialize arguments
		desc.publish_to = to
		map.each { |k, v|
			desc.arguments[k] = v unless %w!publish_from publish_to by!.include?(k)
		}
		
		# initialize filter
		if desc.ht_filter?(desc)
			require 'webpub/abstorel_filter'
			desc.ht_filters << AbsToRelFilter.new
		end
		
		desc
	end
	
	def web_project(file)
		ws = EclipseWorkspace.instance
		ws.project_pathes.each { |proj_name, proj_path|
			return ws.web_project(proj_name) if /^#{proj_path}/i === file
		}
		nil
	end
	
	def choose_prop_from_dir(from)
		web_project = web_project(from)
		
		dir = File.directory?(from) ? from.dup : File.dirname(from) 
		begin
			if File.exist?( f = File.join(dir, '.publish') )
				@publish_definications[f].each { |e|
					f = from.gsub(dir + '/', '')
					if File.basename(f) == e[:pattern] or File::fnmatch?(e[:pattern], f)
						return e[:attributes]
					end
				}
			end
			
			if web_project[:htsources_dir].downcase == dir.downcase
				return {'by' => 'copy'}
			end
		end while dir.sub!(%r!/[^/]+?$!, '') and dir.count('/') > 0
		
		nil
	end
	
	def choose_prop_from_file(file)
		content = nil
		IO.foreach(file) { |l|
			if content = /^<\?publish(.+)\?>$/.match(l)
				attrs = {}
				content[1].scan(/(.+?)\s*=\s*"(.+?)"/) { |m|
					attrs[m[0].strip] = m[1]
				}
				return attrs
			end
		}
		nil
	end
	
end

end
