/*
 * $Id: AmritaErrorHandler.java,v 1.4 2004/04/20 06:52:05 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.publish;

import java.util.regex.*;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.CoreException;

import com.narucy.webpub.core.RubyException;

/**
 * 
 */
class AmritaErrorHandler extends PublishErrorHandler {

	protected IMarker createMarker(IResource res, RubyException ex) throws CoreException {
		IMarker marker = super.createMarker(res, ex);
		
		// handling with script error
		Pattern htParseErrorPattern = Pattern.compile(".*" + res.getName() + ":(\\d+).*");
		Matcher matcher = htParseErrorPattern.matcher(ex.getMessage());
		if(matcher.matches()){
			// parse error handline
			marker.setAttribute(IMarker.LINE_NUMBER, Integer.parseInt(matcher.group(1)));
			return marker;
		}else{
			// script error handle
			IMarker m = createMarkerAsScript(res.getProject(), ex);
			if(m != null){
				marker.setAttribute(PublisherBuilder.ATTR_RELATE_RESOURCE, m.getResource().getFullPath().toString());
			}
		}
		
		return marker;
	}

}
