/*
 * $Id: PublishErrorHandler.java,v 1.2 2004/04/20 06:52:05 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.publish;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;

import com.narucy.webpub.core.RubyException;

/**
 * 
 */
public class PublishErrorHandler {

	/**
	 * default behavior only create marker and set message.
	 */
	protected IMarker createMarker(IResource res, RubyException ex) throws CoreException {
		IMarker marker = getMarker(res, PublisherBuilder.MARKER_MISSED_SRC);
		marker.setAttribute(IMarker.SEVERITY, IMarker.SEVERITY_INFO);
		marker.setAttribute(IMarker.MESSAGE, ex.getMessage());
		return marker;
	}

	/**
	 * returns specify key marker
	 * not set seribity.
	 */
	static IMarker getMarker(IResource res, String type) throws CoreException {
		IMarker[] markers = res.findMarkers(type, false, IResource.DEPTH_ZERO);
		return markers.length > 0 ? markers[0] : res.createMarker(type);
	}
	
	/**
	 * Utility method for create marker from ruby stack trace.
	 */
	protected IMarker createMarkerAsScript(IProject proj, RubyException ex) throws CoreException {
		RubyException.TraceItem[] traces = ex.getTraceItems();
		
		for (int i = 0; i < traces.length; i++) {
			RubyException.TraceItem trace = traces[i];
			Path path = new Path(trace.script);
			IFile scriptFile = path.isAbsolute() ? 
				ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path) :
				proj.getFile(path);
			
			if(scriptFile != null && scriptFile.isAccessible()){
				IMarker marker = getMarker(scriptFile, PublisherBuilder.MARKER_RUBY);
				marker.setAttribute(IMarker.SEVERITY, IMarker.SEVERITY_ERROR);
				marker.setAttribute(IMarker.MESSAGE, ex.getMessage());
				marker.setAttribute(IMarker.LINE_NUMBER, trace.lineNumber);
				marker.setAttribute(PublisherBuilder.ATTR_BACKTRACE, ex.toStackTraceString());
				return marker;
			}
		}
		
		return null;
	}
	

}
