/*
 * $Id: PublishLogStore.java,v 1.8 2004/04/20 06:52:05 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.publish;

import java.io.*;
import java.util.*;
import java.util.regex.Pattern;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

import com.narucy.webpub.core.*;

/**
 *
 */
public class PublishLogStore {

	final public static File
		LOG_STORE_ROOT_DIRECTORY = WebpubPlugin.getDefault().getStateLocation().append("publishLogs").toFile();

	File logStoreDir;
	int entriesParFile = 3;
	
	public PublishLogStore(IProject project){
		logStoreDir = new File(LOG_STORE_ROOT_DIRECTORY, project.getName());
		logStoreDir.mkdirs();
	}
	
	public File getPublishTargetsLocation() {
		return new File(logStoreDir, "publishTargetFiles");
	}
	
	public File[] newLogFiles(String[] suffixes) {
		long time = System.currentTimeMillis();
		File[] logFiles = new File[suffixes.length];
		for (int i = 0; i < suffixes.length; i++) {
			logFiles[i] = new File(logStoreDir, String.valueOf(time) + "." + suffixes[i]);
		}
		return logFiles;
	}
	
	public Date[] getLogDates(){
		ArrayList dist = new ArrayList();
		File[] files = logStoreDir.listFiles();
		if(files != null){
			for (int i = 0; i < files.length; i++) {
				Date date = dateFromFileName(files[i]);
				if(date != null && !dist.contains(date)){
					dist.add(date);
				}
			}
		}
		
		Date[] dates = (Date[]) dist.toArray(new Date[dist.size()]);
		Arrays.sort(dates);
		return dates;
	}
	
	public static Date dateFromFileName(File file){
		String name = file.getName();
		int dotIndex = name.indexOf('.');
		if( dotIndex != -1){
			name = name.substring(0, dotIndex);
		}
		if(Pattern.matches("^\\d+$", name)){
			return new Date(Long.parseLong(name));
		}else{
			return null;
		}
		
	}
	
	public File[] getLogFiles(Date date){
		final long time = date.getTime();
		File[] files = logStoreDir.listFiles( new FileFilter() {
			public boolean accept(File file) {
				if(file.canRead()){
					String n = file.getName();
					int dotIndex = n.indexOf('.');
					if(dotIndex != -1 && Long.parseLong(n.substring(0, dotIndex)) == time){
						return true;
					}
				}
				return false;
			}
		});
		Arrays.sort(files, new Comparator() {
			public boolean equals(Object obj) {
				return false;
			}
			public int compare(Object a, Object b) {
				return ((File)a).getAbsolutePath().compareTo(((File)b).getAbsolutePath());
			}
		});
		
		return files;
	}

	public File getLogFile(Date date, String suffix){
		File[] files = getLogFiles(date);
		for (int i=0; i<files.length; i++) {
			File file = files[i];
			String n = file.getName();
			if(suffix.equals( n.substring(n.indexOf('.') + 1)) ){
				return file;
			}
		}
		return null;
	}
	
	
	public Date[] deleteExcessFiles(){
		Date[] deletedDate = new Date[0];
		
		Date[] dates = getLogDates();
		if(dates.length > entriesParFile){
			int deleteCount = dates.length - entriesParFile;
			deletedDate = new Date[deleteCount];
			for (int i=0; i<deleteCount; i++) {
				File[] files = getLogFiles(dates[i]);
				for (int j=0; j<files.length; j++) {
					files[j].delete();
				}
				deletedDate[i] = dates[i];
			}
		}
		
		return deletedDate;
	}
		
	public void clearLogs(){
		File[] files = logStoreDir.listFiles();
		for (int i = 0; i < files.length; i++) {
			files[i].delete();
		}
	}

	public void dispose(){
		clearAllLogs();
		logStoreDir.delete();
	}
	
	/**
	 * Returns all of log entries.
	 * key: date
	 * value: key represet log file contained web project
	 */
	public static Map getLogEntries(){
		HashMap logEntries = new HashMap();
		try{
			WebProject[] webProjects = WebProject.getWebProjects();
			for (int i = 0; i < webProjects.length; i++) {
				WebProject wp = webProjects[i];
				Date[] dates = wp.getLogStore().getLogDates();
				for (int j=0; j<dates.length; j++) {
					logEntries.put(dates[j], wp);
				}
			}
		}catch(CoreException e){
			WebpubPlugin.handleException(e);
		}
		return logEntries;
	}

	public static void clearAllLogs(){
		File[] dirs = LOG_STORE_ROOT_DIRECTORY.listFiles(new FileFilter() {
			public boolean accept(File f) {
				return f.isDirectory();
			}
		});
		if(dirs != null){
			for (int i=0; i<dirs.length; i++) {
				File[] files = dirs[i].listFiles();
				for (int j = 0; j < files.length; j++) {
					files[j].delete();
				}
			}
		}
	}

}
